/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.history.HistoryManager;
import org.eclipse.tcf.te.runtime.persistence.utils.DataHelper;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDelegateService;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.dialogs.AbstractArraySelectionDialog;
import org.eclipse.tcf.te.tcf.ui.handler.images.ActionHistoryImageDescriptor;
import org.eclipse.tcf.te.tcf.ui.interfaces.IDefaultContextToolbarDelegate;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class ActionHistorySelectionDialog
extends AbstractArraySelectionDialog {
    private int maxEntries = -1;

    public ActionHistorySelectionDialog(Shell shell, String contextHelpId) {
        super(shell, contextHelpId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, Messages.ActionHistorySelectionDialog_button_edit, false);
        this.createButton(parent, 0, Messages.ActionHistorySelectionDialog_button_execute, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (1024 == buttonId) {
            this.editPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void editPressed() {
        Entry entry = this.getSelectedEntry();
        if (entry != null && entry.delegate.execute(entry.peerNode, entry.data, true)) {
            this.close();
        }
    }

    @Override
    protected void okPressed() {
        Entry entry = this.getSelectedEntry();
        super.okPressed();
        if (entry != null && entry.delegate.execute(entry.peerNode, entry.data, false)) {
            this.close();
        }
    }

    protected Entry getSelectedEntry() {
        Object first;
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty() && (first = ((IStructuredSelection)sel).getFirstElement()) instanceof Entry) {
            return (Entry)first;
        }
        return null;
    }

    @Override
    protected void updateEnablement(TableViewer viewer) {
        if (viewer.getTable().getSelectionCount() == 0) {
            viewer.getTable().setSelection(0);
        }
        Entry entry = this.getSelectedEntry();
        Button okButton = this.getButton(0);
        SWTControlUtil.setEnabled((Control)okButton, (entry != null && entry.delegate.validate(entry.peerNode, entry.data) ? 1 : 0) != 0);
        Button editButton = this.getButton(1024);
        SWTControlUtil.setEnabled((Control)editButton, (entry != null ? 1 : 0) != 0);
    }

    protected int getMaxEntries() {
        if (this.maxEntries <= 0) {
            this.maxEntries = UIPlugin.getScopedPreferences().getInt("te.tcf.ui.maxRecentActions");
        }
        return this.maxEntries;
    }

    @Override
    protected Object[] getInput() {
        IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
        IService[] services = ServiceManager.getInstance().getServices((Object)peerNode, IDelegateService.class, false);
        LinkedHashMap<String, IDefaultContextToolbarDelegate> delegates = new LinkedHashMap<String, IDefaultContextToolbarDelegate>();
        IService[] iServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IDefaultContextToolbarDelegate delegate;
            IService service = iServiceArray[n2];
            if (service instanceof IDelegateService && (delegate = (IDefaultContextToolbarDelegate)((IDelegateService)service).getDelegate((Object)peerNode, IDefaultContextToolbarDelegate.class)) != null) {
                String[] stringArray = delegate.getHandledStepGroupIds(peerNode);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String stepGroupId = stringArray[n4];
                    if (!delegates.containsKey(stepGroupId)) {
                        delegates.put(stepGroupId, delegate);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ArrayList<Entry> actions = new ArrayList<Entry>();
        String[] entries = HistoryManager.getInstance().getHistory("org.eclipse.tcf.te.runtime.stepper.last_run_history_id@" + peerNode.getPeerId());
        if (entries != null && entries.length > 0) {
            int count = 0;
            String[] stringArray = entries;
            int n5 = entries.length;
            int n6 = 0;
            while (n6 < n5) {
                String entry = stringArray[n6];
                if (count >= this.getMaxEntries()) break;
                IPropertiesContainer decoded = DataHelper.decodePropertiesContainer((String)entry);
                String stepGroupId = decoded.getStringProperty("org.eclipse.tcf.te.runtime.stepper.step_group_id");
                if (stepGroupId != null && delegates.containsKey(stepGroupId)) {
                    Entry action = new Entry();
                    action.peerNode = peerNode;
                    action.delegate = (IDefaultContextToolbarDelegate)delegates.get(stepGroupId);
                    action.data = entry;
                    actions.add(action);
                    ++count;
                }
                ++n6;
            }
        }
        return actions.toArray();
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(" " + this.getText(cell.getElement()));
                cell.setImage(this.getImage(cell.getElement()));
            }

            public String getToolTipText(Object element) {
                Entry entry = (Entry)element;
                return entry.delegate.getDescription(entry.peerNode, entry.data);
            }

            public String getText(Object element) {
                Entry entry = (Entry)element;
                return entry.delegate.getLabel(entry.peerNode, entry.data);
            }

            public Image getImage(Object element) {
                Entry entry = (Entry)element;
                ActionHistoryImageDescriptor descriptor = new ActionHistoryImageDescriptor(UIPlugin.getDefault().getImageRegistry(), entry.delegate.getImage(entry.peerNode, entry.data), entry.delegate.validate(entry.peerNode, entry.data));
                return UIPlugin.getSharedImage(descriptor);
            }
        };
    }

    @Override
    protected String getDialogTitle() {
        return Messages.ActionHistorySelectionDialog_dialogTitle;
    }

    @Override
    protected String getTitle() {
        IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
        return NLS.bind((String)Messages.ActionHistorySelectionDialog_title, (Object)peerNode.getName());
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.ActionHistorySelectionDialog_message;
    }

    protected static class Entry {
        IPeerNode peerNode;
        IDefaultContextToolbarDelegate delegate;
        String data;

        protected Entry() {
        }
    }
}

