/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.dialogs.AbstractArraySelectionDialog;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;

public class PeerSelectionDialog
extends AbstractArraySelectionDialog
implements ILocatorModelListener {
    public PeerSelectionDialog(Shell shell) {
        super(shell, IContextHelpIds.PEER_SELECTION_DIALOG);
        ModelManager.getLocatorModel().addListener((ILocatorModelListener)this);
    }

    protected void dispose() {
        super.dispose();
        ModelManager.getLocatorModel().removeListener((ILocatorModelListener)this);
    }

    @Override
    protected Object[] getInput() {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        final ILocatorModelRefreshService service = (ILocatorModelRefreshService)ModelManager.getLocatorModel().getService(ILocatorModelRefreshService.class);
        if (service != null) {
            final Callback cb = new Callback();
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    service.refresh((ICallback)cb);
                }
            });
            ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)cb.getDoneConditionTester(null));
        }
        return ModelManager.getLocatorModel().getPeers();
    }

    @Override
    protected String getDialogTitle() {
        return Messages.PeerSelectionDialog_dialogTitle;
    }

    @Override
    protected String getTitle() {
        return Messages.PeerSelectionDialog_title;
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.PeerSelectionDialog_message;
    }

    public void modelChanged(ILocatorModel model, IPeer peer, boolean added) {
        this.refresh();
    }

    public void modelDisposed(ILocatorModel model) {
    }
}

