/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.history.HistoryManager;
import org.eclipse.tcf.te.runtime.persistence.utils.DataHelper;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperOperationService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.locator.services.selection.RuntimeServiceContextFilter;
import org.eclipse.tcf.te.tcf.locator.utils.PeerDataHelper;
import org.eclipse.tcf.te.ui.handler.AbstractStepperCommandHandler;
import org.eclipse.tcf.te.ui.interfaces.IDataExchangeDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractContextStepperCommandHandler
extends AbstractStepperCommandHandler {
    protected void calculateSelectionData(ExecutionEvent event, IPropertiesContainer data) {
        this.setContextList(event, data);
        List<IStructuredSelection> selections = this.getSelections(event);
        for (IStructuredSelection selection : selections) {
            if (selection == null) continue;
            this.addSelection(selection, data);
        }
    }

    protected abstract String[] getServices();

    protected abstract void addSelection(IStructuredSelection var1, IPropertiesContainer var2);

    protected boolean doShowDisconnectedContexts() {
        return false;
    }

    protected IPropertiesContainer getDataFromHistory(ExecutionEvent event) {
        IPeerNode context = this.getContext(event);
        if (context != null) {
            IService[] stepperOpServices;
            IService[] iServiceArray = stepperOpServices = ServiceManager.getInstance().getServices((Object)context, IStepperOperationService.class, false);
            int n = stepperOpServices.length;
            int n2 = 0;
            while (n2 < n) {
                String history;
                String groupId;
                IService stepperOpService = iServiceArray[n2];
                if (stepperOpService instanceof IStepperOperationService && ((IStepperOperationService)stepperOpService).isHandledOperation((Object)context, this.operation) && (groupId = ((IStepperOperationService)stepperOpService).getStepGroupId((Object)context, this.operation)) != null && (history = HistoryManager.getInstance().getFirst(String.valueOf(groupId) + "@" + context.getPeerId())) != null) {
                    return DataHelper.decodePropertiesContainer((String)history);
                }
                ++n2;
            }
        }
        return new PropertiesContainer();
    }

    protected IPeerNode getContext(ExecutionEvent event) {
        IPeerNode[] peerModels;
        IDefaultContextService selService = (IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class);
        if (selService != null && (peerModels = selService.getCandidates((Object)this.getSelection(event), (IDefaultContextService.IContextFilter)new RuntimeServiceContextFilter(this.getServices(), this.doShowDisconnectedContexts()))).length > 0) {
            return peerModels[0];
        }
        return null;
    }

    protected void setContextList(ExecutionEvent event, IPropertiesContainer data) {
        IPeerNode context = this.getContext(event);
        if (context != null) {
            data.setProperty("contextList", (Object)PeerDataHelper.encodeContextList((IPeerNode[])new IPeerNode[]{context}));
        }
    }

    protected String getContextName(IPropertiesContainer data) {
        String encoded = data.getStringProperty("contextList");
        IPeerNode[] contexts = PeerDataHelper.decodeContextList((String)encoded);
        if (contexts != null && contexts.length > 0) {
            return contexts[0].getName();
        }
        return null;
    }

    protected abstract IDataExchangeDialog getDialog(ExecutionEvent var1, IPropertiesContainer var2);

    protected final IPropertiesContainer getData(ExecutionEvent event) {
        IPropertiesContainer data = this.getDataFromHistory(event);
        this.calculateSelectionData(event, data);
        IDataExchangeDialog dialog = this.getDialog(event, data);
        if (dialog != null) {
            dialog.setupData(data);
            if (dialog.open() == 0) {
                String contextList = data.getStringProperty("contextList");
                data = new PropertiesContainer();
                dialog.extractData(data);
                if (!data.containsKey("contextList")) {
                    data.setProperty("contextList", (Object)contextList);
                }
                return data;
            }
            return null;
        }
        return data;
    }

    protected List<IStructuredSelection> getSelections(ExecutionEvent event) {
        ArrayList<IStructuredSelection> selections = new ArrayList<IStructuredSelection>();
        String partId = HandlerUtil.getActivePartId((ExecutionEvent)event);
        selections.add(this.getSelection(event));
        if (!"org.eclipse.ui.navigator.ProjectExplorer".equals(partId)) {
            selections.add(AbstractContextStepperCommandHandler.getPartSelection((String)"org.eclipse.ui.navigator.ProjectExplorer"));
        }
        if (!"org.eclipse.tcf.te.ui.views.View".equals(partId)) {
            selections.add(AbstractContextStepperCommandHandler.getEditorInputSelection());
            selections.add(AbstractContextStepperCommandHandler.getPartSelection((String)"org.eclipse.tcf.te.ui.views.View"));
        }
        return selections;
    }

    protected Object getContext(IPropertiesContainer data) {
        IPeerNode[] contexts = PeerDataHelper.decodeContextList((String)data.getStringProperty("contextList"));
        data.setProperty("contextList", null);
        return contexts.length == 1 ? contexts[0] : null;
    }

    protected IPropertiesContainer cleanupData(IPropertiesContainer data) {
        data = super.cleanupData(data);
        data.setProperty("contextList", null);
        return data;
    }
}

