/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.EventObject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.views.handler.ShowInSystemManagementHandler;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;

public class DefaultContextActionsToolbarContribution
extends WorkbenchWindowControlContribution
implements IWorkbenchContribution,
IEventListener {
    ToolBar toolbar = null;
    ToolItem item = null;
    IServiceLocator serviceLocator = null;
    private MenuManager menuMgr = null;
    private Menu menu = null;
    private boolean clickRunning = false;

    public DefaultContextActionsToolbarContribution() {
        this("org.eclipse.tcf.te.tcf.ui.DefaultContextActionsToolbarContribution");
    }

    public DefaultContextActionsToolbarContribution(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public boolean isDynamic() {
        return true;
    }

    protected Control createControl(Composite parent) {
        this.toolbar = new ToolBar(parent, 0x800000);
        this.item = new ToolItem(this.toolbar, 4);
        this.item.setImage(UIPlugin.getImage("SystemMgmtView"));
        this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                if (peerNode != null && (e.stateMask & SWT.MODIFIER_MASK) != 0 && (e.stateMask & 0x40000) == 262144 && (e.stateMask & 0x20000) == 131072) {
                    ShowInSystemManagementHandler.setAndCheckSelection((String)"org.eclipse.tcf.te.ui.views.View", (Object)peerNode);
                    return;
                }
                DefaultContextActionsToolbarContribution.this.onButtonClick();
            }
        });
        EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
        this.update();
        return this.toolbar;
    }

    public void dispose() {
        super.dispose();
        EventManager.getInstance().removeEventListener((IEventListener)this);
        this.item.dispose();
        this.toolbar.dispose();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.setVisible(false);
            this.menu.dispose();
            this.menu = null;
        }
        if (this.menuMgr != null) {
            this.menuMgr.dispose();
            this.menuMgr = null;
        }
    }

    protected void onButtonClick() {
        if (!this.clickRunning) {
            this.clickRunning = true;
            this.update();
            this.createContextMenu((Composite)this.toolbar);
            if (this.menu != null) {
                Point point = this.toolbar.toDisplay(this.toolbar.getLocation());
                this.menu.setLocation(point.x, point.y + this.toolbar.getBounds().height);
                this.menu.setVisible(true);
            }
            this.clickRunning = false;
        }
    }

    public void update() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.setVisible(false);
            this.menu.dispose();
            this.menu = null;
        }
        if (this.menuMgr != null) {
            this.menuMgr.dispose();
        }
        if (this.item != null && !this.item.isDisposed()) {
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (peerNode == null) {
                this.item.setToolTipText(Messages.DefaultContextActionsToolbarContribution_tooltip_button_noContext);
                this.item.setEnabled(false);
            } else {
                this.item.setToolTipText(Messages.DefaultContextActionsToolbarContribution_tooltip_button);
                this.item.setEnabled(true);
            }
        }
    }

    protected void createContextMenu(Composite panel) {
        try {
            this.menuMgr = new MenuManager();
            this.menuMgr.add((IContributionItem)new Separator("group.connect"));
            this.menuMgr.add((IContributionItem)new Separator("group.launch"));
            this.menuMgr.add((IContributionItem)new Separator("group.launch.rundebug"));
            this.menuMgr.add((IContributionItem)new Separator("group.history"));
            this.menuMgr.add((IContributionItem)new Separator("group.additions"));
            IMenuService service = (IMenuService)this.serviceLocator.getService(IMenuService.class);
            service.populateContributionManager((ContributionManager)this.menuMgr, "menu:" + this.getId());
            IContributionItem[] iContributionItemArray = this.menuMgr.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.update();
                ++n2;
            }
            this.menu = this.menuMgr.createContextMenu((Control)panel);
        }
        catch (Exception e) {
            if (Platform.inDebugMode()) {
                Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log(StatusHelper.getStatus((Throwable)e));
            }
            this.menuMgr = null;
            this.menu = null;
        }
    }

    public void eventFired(EventObject event) {
        if (event instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)event;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (changeEvent.getSource() instanceof IDefaultContextService || changeEvent.getSource() == peerNode && ("connectState".equals(changeEvent.getEventId()) || "properties".equals(changeEvent.getEventId()))) {
                ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DefaultContextActionsToolbarContribution.this.update();
                    }
                });
            }
        }
    }
}

