/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.handler.NewToolbarWizardHandler;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.handler.OpenEditorHandler;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DefaultContextSelectorToolbarContribution
extends WorkbenchWindowControlContribution
implements IWorkbenchContribution,
IEventListener,
IPeerModelListener {
    private Composite panel = null;
    private Label image = null;
    private Label text = null;
    private Button button = null;
    IServiceLocator serviceLocator = null;
    private MenuManager menuMgr = null;
    private Menu menu = null;
    private boolean clickRunning = false;

    public DefaultContextSelectorToolbarContribution() {
        this("org.eclipse.tcf.te.tcf.ui.DefaultContextSelectorToolbarContribution");
    }

    public DefaultContextSelectorToolbarContribution(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected Control createControl(Composite parent) {
        this.panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.panel.setLayout((Layout)layout);
        Composite labelPanel = new Composite(this.panel, 2048);
        labelPanel.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        labelPanel.setLayoutData((Object)layoutData);
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        labelPanel.setLayout((Layout)layout);
        this.image = new Label(labelPanel, 0);
        layoutData = new GridData(16384, 0x1000000, false, true);
        layoutData.horizontalIndent = 1;
        layoutData.minimumWidth = 20;
        layoutData.widthHint = 20;
        this.image.setLayoutData((Object)layoutData);
        this.image.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                DefaultContextSelectorToolbarContribution.this.onButtonClick();
            }
        });
        this.text = new Label(labelPanel, 0);
        layoutData = new GridData(4, 0x1000000, true, true);
        layoutData.minimumWidth = SWTControlUtil.convertWidthInCharsToPixels((Control)this.text, (int)25);
        this.text.setLayoutData((Object)layoutData);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                if (peerNode != null && (e.stateMask & SWT.MODIFIER_MASK) != 0 && (e.stateMask & 0x40000) == 262144 && (e.stateMask & 0x20000) == 131072) {
                    OpenEditorHandler.openEditorOnSelection((IWorkbenchWindow)DefaultContextSelectorToolbarContribution.this.getWorkbenchWindow(), (ISelection)new StructuredSelection((Object)peerNode));
                    return;
                }
                DefaultContextSelectorToolbarContribution.this.onButtonClick();
            }
        });
        this.button = new Button(labelPanel, 0x880404);
        layoutData = new GridData(131072, 0x1000000, false, true);
        layoutData.minimumWidth = 20;
        layoutData.widthHint = 20;
        this.button.setLayoutData((Object)layoutData);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultContextSelectorToolbarContribution.this.onButtonClick();
            }
        });
        EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
        ModelManager.getPeerModel().addListener((IPeerModelListener)this);
        this.update();
        return this.panel;
    }

    public void dispose() {
        super.dispose();
        EventManager.getInstance().removeEventListener((IEventListener)this);
        ModelManager.getPeerModel().removeListener((IPeerModelListener)this);
        this.image.dispose();
        this.text.dispose();
        if (this.menuMgr != null) {
            this.menuMgr.dispose();
        }
        this.image = null;
        this.text = null;
    }

    private IPeerNode[] getPeerNodesSorted() {
        IPeerNode[] peerNodes = ModelManager.getPeerModel().getPeerNodes();
        ArrayList<IPeerNode> visiblePeerNodes = new ArrayList<IPeerNode>();
        IPeerNode[] iPeerNodeArray = peerNodes;
        int n = peerNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode peerNode = iPeerNodeArray[n2];
            if (peerNode.isVisible()) {
                visiblePeerNodes.add(peerNode);
            }
            ++n2;
        }
        Collections.sort(visiblePeerNodes, new Comparator<IPeerNode>(){

            @Override
            public int compare(IPeerNode o1, IPeerNode o2) {
                String type1 = o1.getPeerType();
                type1 = type1 != null ? type1 : "";
                String type2 = o2.getPeerType();
                type2 = type2 != null ? type2 : "";
                int typeCompare = type1.compareTo(type2);
                return typeCompare != 0 ? typeCompare : o1.getName().toUpperCase().compareTo(o2.getName().toUpperCase());
            }
        });
        return visiblePeerNodes.toArray(new IPeerNode[visiblePeerNodes.size()]);
    }

    public void update() {
        if (this.menuMgr != null) {
            this.menuMgr.markDirty();
        }
        if (this.image != null && this.text != null) {
            IPeerNode[] peerNodes;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (peerNode == null && (peerNodes = this.getPeerNodesSorted()) != null && peerNodes.length > 0) {
                peerNode = peerNodes[0];
                ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext(peerNode);
                return;
            }
            if (peerNode != null) {
                String fullName;
                DelegatingLabelProvider labelProvider = new DelegatingLabelProvider();
                this.image.setImage(labelProvider.decorateImage(labelProvider.getImage((Object)peerNode), (Object)peerNode));
                String name = fullName = labelProvider.getText((Object)peerNode);
                if (name.length() > 22 && name.length() >= 25) {
                    name = String.valueOf(name.substring(0, 22)) + "...";
                }
                this.text.setText(name);
                this.image.setToolTipText(!fullName.equals(name) ? fullName : Messages.DefaultContextSelectorToolbarContribution_tooltip_button);
                this.text.setToolTipText(!fullName.equals(name) ? fullName : Messages.DefaultContextSelectorToolbarContribution_tooltip_button);
                this.button.setToolTipText(Messages.DefaultContextSelectorToolbarContribution_tooltip_button);
            } else {
                this.image.setImage(UIPlugin.getImage("NewConfig"));
                this.text.setText(Messages.DefaultContextSelectorToolbarContribution_label_new);
                this.image.setToolTipText(Messages.DefaultContextSelectorToolbarContribution_tooltip_new);
                this.text.setToolTipText(Messages.DefaultContextSelectorToolbarContribution_tooltip_new);
                this.button.setToolTipText(Messages.DefaultContextSelectorToolbarContribution_tooltip_new);
            }
        }
    }

    protected void onButtonClick() {
        if (!this.clickRunning) {
            this.clickRunning = true;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (peerNode == null) {
                this.openNewWizard();
            } else {
                this.createContextMenu(this.panel);
                if (this.menu != null) {
                    Point point = this.panel.toDisplay(this.panel.getLocation());
                    this.menu.setLocation(point.x, point.y + this.panel.getBounds().height);
                    this.menu.setVisible(true);
                }
            }
            this.clickRunning = false;
        }
    }

    protected void openNewWizard() {
        try {
            new NewToolbarWizardHandler().execute(new ExecutionEvent());
        }
        catch (Exception exception) {}
    }

    public boolean isDynamic() {
        return true;
    }

    protected void createContextMenu(Composite panel) {
        if (this.menu == null || this.menuMgr == null || this.menuMgr.isDirty()) {
            try {
                if (this.menuMgr != null) {
                    this.menuMgr.dispose();
                }
                this.menuMgr = new MenuManager();
                this.menuMgr.add((IContributionItem)new GroupMarker("group.configurations"));
                IPeerNode defaultContext = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                IPeerNode[] iPeerNodeArray = this.getPeerNodesSorted();
                int n = iPeerNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n2];
                    if (peerNode != defaultContext && peerNode.isVisible()) {
                        Action action = new Action(peerNode){
                            private IPeerNode node;
                            {
                                this.node = iPeerNode;
                            }

                            public void run() {
                                ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext(this.node);
                            }
                        };
                        DelegatingLabelProvider labelProvider = new DelegatingLabelProvider();
                        action.setText(labelProvider.getText((Object)peerNode));
                        Image image = labelProvider.decorateImage(labelProvider.getImage((Object)peerNode), (Object)peerNode);
                        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
                        this.menuMgr.add((IAction)action);
                    }
                    ++n2;
                }
                this.menuMgr.add((IContributionItem)new Separator("group.open"));
                this.menuMgr.add((IContributionItem)new GroupMarker("group.delete"));
                this.menuMgr.add((IContributionItem)new GroupMarker("group.new"));
                this.menuMgr.add((IContributionItem)new Separator("group.additions"));
                IMenuService service = (IMenuService)this.serviceLocator.getService(IMenuService.class);
                service.populateContributionManager((ContributionManager)this.menuMgr, "menu:" + this.getId());
                if (this.menu != null && !this.menu.isDisposed()) {
                    this.menu.setVisible(false);
                    this.menu.dispose();
                }
                this.menu = this.menuMgr.createContextMenu((Control)panel);
            }
            catch (Exception exception) {
                this.menuMgr = null;
                this.menu = null;
            }
        }
    }

    protected ILabelProvider getLabelProvider(IPeerNode peerNode) {
        ILabelProvider labelProvider = (ILabelProvider)peerNode.getAdapter(ILabelProvider.class);
        if (labelProvider == null) {
            labelProvider = (ILabelProvider)Platform.getAdapterManager().loadAdapter((Object)peerNode, ILabelProvider.class.getName());
        }
        return labelProvider;
    }

    public void eventFired(EventObject event) {
        if (event instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)event;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            boolean openEditorOnChange = UIPlugin.getScopedPreferences().getBoolean("org.eclipse.tcf.te.tcf.ui.defaultcontext.open.editor");
            if (peerNode != null && changeEvent.getSource() instanceof IDefaultContextService) {
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                service.refreshElements("org.eclipse.tcf.te.ui.toolbar.command.connect", null);
                service.refreshElements("org.eclipse.tcf.te.ui.toolbar.command.disconnect", null);
                if (openEditorOnChange) {
                    ViewsUtil.openEditor((ISelection)new StructuredSelection((Object)peerNode));
                }
            }
            if (changeEvent.getSource() instanceof IDefaultContextService || changeEvent.getSource() == peerNode && ("connectState".equals(changeEvent.getEventId()) || "valid".equals(changeEvent.getEventId()) || "properties".equals(changeEvent.getEventId()))) {
                if (this.menuMgr != null) {
                    this.menuMgr.markDirty();
                }
                ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DefaultContextSelectorToolbarContribution.this.update();
                    }
                });
            }
        }
    }

    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        if (this.menuMgr != null) {
            this.menuMgr.markDirty();
        }
        ExecutorsUtil.executeInUI((Runnable)new Runnable(){

            @Override
            public void run() {
                DefaultContextSelectorToolbarContribution.this.update();
            }
        });
    }

    public void modelDisposed(IPeerModel model) {
    }
}

