/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.interfaces.handler.IDeleteHandlerDelegate;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategoryManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    private Shell shell = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = this.getSelection(event);
        if (selection != null) {
            this.delete(selection, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                }
            });
        }
        this.shell = null;
        return null;
    }

    protected ISelection getSelection(ExecutionEvent event) {
        return HandlerUtil.getCurrentSelection((ExecutionEvent)event);
    }

    public boolean canDelete(ISelection selection) {
        Assert.isNotNull((Object)selection);
        boolean canDelete = false;
        if (!(selection instanceof ITreeSelection) && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            ArrayList<TreePath> treePathes = new ArrayList<TreePath>();
            while (it.hasNext()) {
                Object sel = it.next();
                treePathes.add(new TreePath(new Object[]{sel}));
            }
            selection = new TreeSelection(treePathes.toArray(new TreePath[treePathes.size()]));
        }
        if (selection instanceof ITreeSelection && !selection.isEmpty()) {
            canDelete = true;
            TreePath[] treePathArray = ((ITreeSelection)selection).getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDeleteHandlerDelegate delegate;
                TreePath treePath = treePathArray[n2];
                Object element = treePath.getLastSegment();
                if (!(element instanceof IPeerNode)) {
                    canDelete = false;
                    break;
                }
                IUIService service = (IUIService)ServiceManager.getInstance().getService(element, IUIService.class);
                IDeleteHandlerDelegate iDeleteHandlerDelegate = delegate = service != null ? (IDeleteHandlerDelegate)service.getDelegate(element, IDeleteHandlerDelegate.class) : null;
                if (delegate != null) {
                    canDelete = delegate.canDelete(treePath);
                }
                if (!canDelete) break;
                ++n2;
            }
        }
        return canDelete;
    }

    public void delete(ISelection selection, final ICallback callback) {
        Operation[] operations;
        boolean confirmed;
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)callback);
        boolean invokeCallback = true;
        if (!(selection instanceof ITreeSelection) && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            ArrayList<TreePath> treePathes = new ArrayList<TreePath>();
            while (it.hasNext()) {
                Object sel = it.next();
                treePathes.add(new TreePath(new Object[]{sel}));
            }
            selection = new TreeSelection(treePathes.toArray(new TreePath[treePathes.size()]));
        }
        if (selection instanceof ITreeSelection && !selection.isEmpty() && (confirmed = this.confirmDelete(operations = this.selection2operations((ITreeSelection)selection)))) {
            boolean refreshModel = false;
            try {
                Operation[] operationArray = operations;
                int n = operations.length;
                int n2 = 0;
                while (n2 < n) {
                    Operation op = operationArray[n2];
                    if (Operation.TYPE.Remove.equals((Object)op.type)) {
                        refreshModel = true;
                    }
                    op.execute();
                    ++n2;
                }
            }
            catch (Exception e) {
                String template = NLS.bind((String)Messages.DeleteHandler_error_deleteFailed, (Object)Messages.PossibleCause);
                StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)selection, (String)template, (String)Messages.DeleteHandler_error_title, (String)IContextHelpIds.MESSAGE_DELETE_FAILED, (Object)((Object)this), null);
            }
            if (refreshModel) {
                invokeCallback = false;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IPeerModelRefreshService service = (IPeerModelRefreshService)ModelManager.getPeerModel().getService(IPeerModelRefreshService.class);
                        if (service != null) {
                            service.refresh((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    callback.done((Object)DeleteHandler.this, Status.OK_STATUS);
                                }
                            });
                        }
                    }
                });
            }
        }
        if (invokeCallback) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    private Operation[] selection2operations(ITreeSelection selection) {
        Assert.isNotNull((Object)selection);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        TreePath[] treePathArray = selection.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object element = treePath.getLastSegment();
            Assert.isTrue((boolean)(element instanceof IPeerNode));
            IPeerNode node = (IPeerNode)element;
            ICategory category = treePath.getFirstSegment() instanceof ICategory ? (ICategory)treePath.getFirstSegment() : null;
            Operation op = new Operation();
            op.type = category != null && "org.eclipse.tcf.te.ui.views.category.favorites".equals(category.getId()) ? Operation.TYPE.Unlink : Operation.TYPE.Remove;
            op.node = node;
            op.parentCategory = category;
            operations.add(op);
            ++n2;
        }
        return operations.toArray(new Operation[operations.size()]);
    }

    private boolean confirmDelete(Operation[] operations) {
        Assert.isNotNull((Object)operations);
        boolean confirmed = false;
        ArrayList<Operation> toRemove = new ArrayList<Operation>();
        Operation[] operationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            Operation op = operationArray[n2];
            if (Operation.TYPE.Remove.equals((Object)op.type)) {
                toRemove.add(op);
            }
            ++n2;
        }
        if (!toRemove.isEmpty()) {
            String question = this.getConfirmQuestion(toRemove);
            Shell parent = this.shell != null ? this.shell : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            confirmed = MessageDialog.openQuestion((Shell)parent, (String)Messages.DeleteHandlerDelegate_DialogTitle, (String)question);
        } else {
            confirmed = true;
        }
        return confirmed;
    }

    private String getConfirmQuestion(List<Operation> toRemove) {
        String question;
        Assert.isNotNull(toRemove);
        if (toRemove.size() == 1) {
            final Operation op = toRemove.get(0);
            final AtomicReference name = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    name.set(op.node.getPeer().getName());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            question = NLS.bind((String)Messages.DeleteHandlerDelegate_MsgDeleteOnePeer, name.get());
        } else {
            question = NLS.bind((String)Messages.DeleteHandlerDelegate_MsgDeleteMultiplePeers, (Object)toRemove.size());
        }
        return question;
    }

    private static class Operation {
        public IPeerNode node;
        public TYPE type;
        public ICategory parentCategory;

        public void execute() throws Exception {
            Assert.isNotNull((Object)this.node);
            Assert.isNotNull((Object)((Object)this.type));
            if (TYPE.Remove.equals((Object)this.type)) {
                IUIService uiService;
                IDeleteHandlerDelegate delegate;
                IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (service == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                service.delete((Object)this.node, null);
                if (this.parentCategory != null) {
                    ViewsUtil.setSelection((String)"org.eclipse.tcf.te.ui.views.View", (ISelection)new StructuredSelection((Object)this.parentCategory));
                }
                IDeleteHandlerDelegate iDeleteHandlerDelegate = delegate = (uiService = (IUIService)ServiceManager.getInstance().getService((Object)this.node, IUIService.class)) != null ? (IDeleteHandlerDelegate)uiService.getDelegate((Object)this.node, IDeleteHandlerDelegate.class) : null;
                if (delegate != null) {
                    delegate.postDelete((Object)this.node);
                }
            } else if (TYPE.Unlink.equals((Object)this.type)) {
                Assert.isNotNull((Object)this.parentCategory);
                ICategoryManager manager = Managers.getCategoryManager();
                Assert.isNotNull((Object)manager);
                ICategorizable categorizable = (ICategorizable)this.node.getAdapter(ICategorizable.class);
                if (categorizable == null) {
                    categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)this.node, ICategorizable.class);
                }
                Assert.isNotNull((Object)categorizable);
                manager.remove(this.parentCategory.getId(), categorizable.getId());
                ViewsUtil.setSelection((String)"org.eclipse.tcf.te.ui.views.View", (ISelection)new StructuredSelection((Object)this.parentCategory));
            }
        }

        public static enum TYPE {
            Remove,
            Unlink;

        }
    }
}

