/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null) {
            this.refresh(selection, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                }
            });
        }
        return null;
    }

    public void refresh(ISelection selection, ICallback callback) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)callback);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            ArrayList<IPeerModel> locatorToRefresh = new ArrayList<IPeerModel>();
            ArrayList<IPeerNode> peerToRefresh = new ArrayList<IPeerNode>();
            for (Object element : (IStructuredSelection)selection) {
                Assert.isTrue((boolean)(element instanceof IPeerNode));
                IPeerNode node = (IPeerNode)element;
                IPeerModel model = (IPeerModel)node.getAdapter(IPeerModel.class);
                Assert.isNotNull((Object)model);
                if (!locatorToRefresh.contains(model)) {
                    locatorToRefresh.add(model);
                }
                if (peerToRefresh.contains(node)) continue;
                peerToRefresh.add(node);
            }
            AsyncCallbackCollector collector = new AsyncCallbackCollector(callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
            Iterator iterator = locatorToRefresh.iterator();
            while (iterator.hasNext()) {
                IPeerModel model;
                final IPeerModel finModel = model = (IPeerModel)iterator.next();
                AsyncCallbackCollector.SimpleCollectorCallback innerCallback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                Runnable runnable = new Runnable((ICallback)innerCallback){
                    private final /* synthetic */ ICallback val$innerCallback;
                    {
                        this.val$innerCallback = iCallback;
                    }

                    @Override
                    public void run() {
                        ((IPeerModelRefreshService)finModel.getService(IPeerModelRefreshService.class)).refresh((ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                val$innerCallback.done((Object)this, Status.OK_STATUS);
                            }
                        });
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
            collector.initDone();
        } else {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }
}

