/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator.images;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;

public class PeerNodeImageDescriptor
extends AbstractImageDescriptor {
    private Image baseImage;
    private Point imageSize;
    private int connectState;
    private boolean valid;

    public PeerNodeImageDescriptor(ImageRegistry registry, Image baseImage, IPeerNode node) {
        super(registry);
        this.baseImage = baseImage;
        this.imageSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
        this.initialize(node);
        this.defineKey(baseImage.hashCode());
    }

    protected void initialize(IPeerNode node) {
        Assert.isNotNull((Object)node);
        this.connectState = node.getConnectState();
        this.valid = node.isValid();
    }

    protected void defineKey(int hashCode) {
        String key = "PNID:" + hashCode + ":" + this.connectState + ":" + this.valid;
        this.setDecriptorKey(key);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawCentered(this.baseImage, width, height);
        if (!this.valid) {
            this.drawBottomRight("RedXOverlay");
        } else {
            if (this.connectState < 0) {
                this.drawTopRight("BusyOverlay");
            }
            if (this.connectState == 11) {
                this.drawBottomRight("GreenOverlay");
            } else if (this.connectState == -12 || this.connectState == -2 || this.connectState == 21 || this.connectState == -21) {
                this.drawBottomRight("GreyOverlay");
            }
        }
    }

    protected Point getSize() {
        return this.imageSize;
    }

    protected Image getBaseImage() {
        return this.baseImage;
    }
}

