/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.wizards.AbstractWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractNewConfigWizard
extends AbstractWizard
implements INewWizard {
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(this.getWizardTitle());
        this.setNeedsProgressMonitor(true);
    }

    protected abstract String getWizardTitle();

    protected boolean isOpenEditorOnPerformFinish() {
        return true;
    }

    protected void postPerformFinish(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext(peerNode);
        boolean autoConnect = true;
        if (System.getProperty("NoWizardAutoConnect") != null) {
            autoConnect &= !Boolean.getBoolean("NoWizardAutoConnect");
        }
        if (!(autoConnect &= !UIPlugin.getDefault().getPreferenceStore().getBoolean("NoWizardAutoConnect"))) {
            return;
        }
        final AtomicBoolean connect = new AtomicBoolean();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                connect.set(Boolean.parseBoolean((String)peerNode.getPeer().getAttributes().get("autoConnect")));
            }
        });
        if (connect.get()) {
            peerNode.changeConnectState(11, null, null);
        }
    }
}

