/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.notifications.internal.popup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.ui.notifications.activator.UIPlugin;
import org.eclipse.tcf.te.ui.notifications.interfaces.IFormTextFactoryDelegate;
import org.eclipse.tcf.te.ui.notifications.internal.factory.FactoryDelegateManager;
import org.eclipse.tcf.te.ui.notifications.internal.popup.AbstractNotificationPopup;
import org.eclipse.tcf.te.ui.notifications.internal.popup.ScalingHyperlink;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NotificationPopup
extends AbstractNotificationPopup {
    private static final int NUM_NOTIFICATIONS_TO_DISPLAY = 4;
    Color hyperlinkWidget = null;
    private List<NotifyEvent> notifications;

    public NotificationPopup(Shell parent) {
        super(parent.getDisplay());
    }

    @Override
    protected void createContentArea(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.hyperlinkWidget = new Color((Device)parent.getDisplay(), 12, 81, 172);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NotificationPopup.this.hyperlinkWidget != null) {
                    NotificationPopup.this.hyperlinkWidget.dispose();
                    NotificationPopup.this.hyperlinkWidget = null;
                }
            }
        });
        int count = 0;
        for (NotifyEvent notification : this.notifications) {
            IFormTextFactoryDelegate delegate;
            Composite notificationComposite = new Composite(parent, 524288);
            notificationComposite.setLayoutData((Object)new GridData(4, 128, true, false));
            notificationComposite.setLayout((Layout)new GridLayout(1, false));
            notificationComposite.setBackground(parent.getBackground());
            if (count < 4) {
                delegate = null;
                if (notification.getFactoryId() != null) {
                    delegate = FactoryDelegateManager.getInstance().getFactoryDelegate(notification.getFactoryId());
                }
                if (delegate == null) {
                    delegate = FactoryDelegateManager.getInstance().getDefaultFactoryDelegate();
                }
            } else {
                int numNotificationsRemain = this.notifications.size() - count;
                ScalingHyperlink remainingLink = new ScalingHyperlink(notificationComposite, 524288);
                remainingLink.setForeground(this.hyperlinkWidget);
                remainingLink.registerMouseTrackListener();
                remainingLink.setBackground(parent.getBackground());
                remainingLink.setText(NLS.bind((String)"{0} more", (Object)numNotificationsRemain));
                remainingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        Shell windowShell;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (windowShell = window.getShell()) != null) {
                            windowShell.setMaximized(true);
                            windowShell.open();
                        }
                    }
                });
                break;
            }
            Assert.isNotNull(delegate);
            FormToolkit toolkit = UIPlugin.getDefault().getFormToolkit();
            Assert.isNotNull((Object)toolkit);
            FormText widget = toolkit.createFormText(notificationComposite, true);
            GridData layoutData = new GridData(4, 128, true, false);
            layoutData.widthHint = 300;
            widget.setLayoutData((Object)layoutData);
            widget.setBackground(notificationComposite.getBackground());
            widget.setWhitespaceNormalized(false);
            widget.setData("event", (Object)notification);
            delegate.populateFormText(toolkit, widget, notification);
            this.setDelayClose(delegate.getNotificationCloseDelay());
            ++count;
        }
    }

    public List<NotifyEvent> getNotifications() {
        return new ArrayList<NotifyEvent>(this.notifications);
    }

    @Override
    protected Color getTitleForeground() {
        return UIPlugin.getDefault().getFormToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
    }

    public void setContents(List<NotifyEvent> notifications) {
        Assert.isNotNull(notifications);
        this.notifications = notifications;
    }
}

