/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.controls;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractConfigurationPanel;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LocalWizardConfigurationPanel
extends AbstractConfigurationPanel
implements IDataExchangeNode {
    private IResource resource;

    public LocalWizardConfigurationPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createEncodingUI(panel, false);
        if ("macosx".equals(Platform.getOS())) {
            this.setEncoding("UTF-8");
        } else {
            String encoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                this.setEncoding(encoding);
            }
        }
        Label label = new Label(panel, 256);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 300;
        layoutData.heightHint = 80;
        label.setLayoutData((Object)layoutData);
        this.resource = this.getSelectionResource();
        this.setControl(panel);
    }

    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        return false;
    }

    public void setupData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        String value = data.getStringProperty("encoding");
        if (value != null) {
            this.setEncoding(value);
        }
    }

    public void extractData(IPropertiesContainer data) {
        data.setProperty("tm.terminal.connector.id", (Object)"org.eclipse.tcf.te.ui.terminals.local.LocalConnector");
        data.setProperty("connector.type.id", (Object)"org.eclipse.tcf.te.ui.terminals.type.local");
        data.setProperty("encoding", (Object)this.getEncoding());
        if (this.resource != null) {
            String dir = this.resource.getProject().getLocation().toString();
            data.setProperty("process.working_dir", (Object)dir);
        }
    }

    protected void fillSettingsForHost(String host) {
    }

    protected void saveSettingsForHost(boolean add) {
    }

    public boolean isValid() {
        return true;
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
    }

    protected String getHostFromSettings() {
        return null;
    }

    public boolean isWithHostList() {
        return false;
    }

    private IResource getSelectionResource() {
        StructuredSelection selection;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        Object object = selection = selectionService != null ? selectionService.getSelection() : StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                return (IResource)element;
            }
            if (element instanceof IAdaptable) {
                return (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
        }
        return null;
    }
}

