/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.ssh.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.ssh.nls.Messages;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.ssh.SshConnector;
import org.eclipse.tm.internal.terminal.ssh.SshSettings;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SshWizardConfigurationPanel
extends AbstractConfigurationPanel
implements IDataExchangeNode {
    private static final String SAVE_PASSWORD = "savePassword";
    private SshSettings sshSettings;
    private ISettingsPage sshSettingsPage;
    private Button passwordButton;

    public SshWizardConfigurationPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        if (this.isWithoutSelection()) {
            this.createHostsUI(panel, true);
        }
        SshConnector conn = new SshConnector();
        this.sshSettings = (SshSettings)conn.getSshSettings();
        this.sshSettings.setHost(this.getSelectionHost());
        this.sshSettings.setUser(this.getDefaultUser());
        this.sshSettingsPage = conn.makeSettingsPage();
        if (this.sshSettingsPage instanceof AbstractSettingsPage) {
            ((AbstractSettingsPage)this.sshSettingsPage).setHasControlDecoration(true);
        }
        this.sshSettingsPage.createControl(panel);
        if (this.getParentControl() instanceof IValidatingContainer) {
            this.sshSettingsPage.addListener(new ISettingsPage.Listener(){

                public void onSettingsPageChanged(Control control) {
                    ((IValidatingContainer)SshWizardConfigurationPanel.this.getParentControl()).validate();
                }
            });
        }
        this.createEncodingUI(panel, true);
        this.createPasswordUI(panel, true);
        this.setControl(panel);
    }

    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        return false;
    }

    public void setupData(IPropertiesContainer data) {
        if (data == null || this.sshSettings == null || this.sshSettingsPage == null) {
            return;
        }
        String value = data.getStringProperty("ip.host");
        if (value != null) {
            this.sshSettings.setHost(value);
        }
        if ((value = data.getStringProperty("ip.port")) != null) {
            this.sshSettings.setPort(value);
        }
        if ((value = data.getStringProperty("timeout")) != null) {
            this.sshSettings.setTimeout(value);
        }
        if ((value = data.getStringProperty("ssh.keep_alive")) != null) {
            this.sshSettings.setKeepalive(value);
        }
        if ((value = data.getStringProperty("ssh.password")) != null) {
            this.sshSettings.setPassword(value);
        }
        if ((value = data.getStringProperty("ssh.user")) != null) {
            this.sshSettings.setUser(value);
        }
        if ((value = data.getStringProperty("encoding")) != null) {
            this.setEncoding(value);
        }
        this.sshSettingsPage.loadSettings();
    }

    private String getDefaultUser() {
        return System.getProperty("user.name");
    }

    public void extractData(IPropertiesContainer data) {
        data.setProperty("tm.terminal.connector.id", (Object)"org.eclipse.tm.internal.terminal.ssh.SshConnector");
        data.setProperty("connector.type.id", (Object)"org.eclipse.tcf.te.ui.terminals.type.ssh");
        this.sshSettingsPage.saveSettings();
        data.setProperty("ip.host", (Object)this.sshSettings.getHost());
        data.setProperty("ip.port", this.sshSettings.getPort());
        data.setProperty("timeout", this.sshSettings.getTimeout());
        data.setProperty("ssh.keep_alive", this.sshSettings.getKeepalive());
        data.setProperty("ssh.password", (Object)this.sshSettings.getPassword());
        data.setProperty("ssh.user", (Object)this.sshSettings.getUser());
        data.setProperty("encoding", (Object)this.getEncoding());
    }

    protected void fillSettingsForHost(String host) {
        boolean savePassword = false;
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                if (hostSettings.get("ip.host") != null) {
                    this.sshSettings.setHost((String)hostSettings.get("ip.host"));
                }
                if (hostSettings.get("ip.port") != null) {
                    this.sshSettings.setPort((String)hostSettings.get("ip.port"));
                }
                if (hostSettings.get("timeout") != null) {
                    this.sshSettings.setTimeout((String)hostSettings.get("timeout"));
                }
                if (hostSettings.get("ssh.keep_alive") != null) {
                    this.sshSettings.setKeepalive((String)hostSettings.get("ssh.keep_alive"));
                }
                if (hostSettings.get("ssh.user") != null) {
                    this.sshSettings.setUser((String)hostSettings.get("ssh.user"));
                }
                if (hostSettings.get(SAVE_PASSWORD) != null) {
                    savePassword = new Boolean((String)hostSettings.get(SAVE_PASSWORD));
                }
                if (!savePassword) {
                    this.sshSettings.setPassword("");
                } else {
                    String password = this.accessSecurePassword(this.sshSettings.getHost());
                    if (password != null) {
                        this.sshSettings.setPassword(password);
                    }
                }
                String encoding = (String)hostSettings.get("encoding");
                if (encoding == null || "null".equals(encoding)) {
                    encoding = "ISO-8859-1";
                }
                this.setEncoding(encoding);
            } else {
                this.sshSettings.setHost(this.getSelectionHost());
                this.sshSettings.setUser(this.getDefaultUser());
                savePassword = false;
            }
            this.sshSettingsPage.loadSettings();
            this.passwordButton.setSelection(savePassword);
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.saveSettingsForHost(true);
        super.doSaveWidgetValues(settings, idPrefix);
    }

    protected void saveSettingsForHost(boolean add) {
        boolean savePassword = this.passwordButton.getSelection();
        String host = this.getHostFromSettings();
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                hostSettings.put("ip.host", this.sshSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.sshSettings.getPort()));
                hostSettings.put("timeout", Integer.toString(this.sshSettings.getTimeout()));
                hostSettings.put("ssh.keep_alive", Integer.toString(this.sshSettings.getKeepalive()));
                hostSettings.put("ssh.user", this.sshSettings.getUser());
                hostSettings.put("encoding", this.getEncoding());
                hostSettings.put(SAVE_PASSWORD, Boolean.toString(savePassword));
                if (savePassword && this.sshSettings.getPassword() != null && this.sshSettings.getPassword().length() != 0) {
                    this.saveSecurePassword(host, this.sshSettings.getPassword());
                }
                if (!savePassword) {
                    this.removeSecurePassword(host);
                }
            } else if (add) {
                HashMap<String, String> hostSettings = new HashMap<String, String>();
                hostSettings.put("ip.host", this.sshSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.sshSettings.getPort()));
                hostSettings.put("timeout", Integer.toString(this.sshSettings.getTimeout()));
                hostSettings.put("ssh.keep_alive", Integer.toString(this.sshSettings.getKeepalive()));
                hostSettings.put("ssh.user", this.sshSettings.getUser());
                hostSettings.put("encoding", this.getEncoding());
                hostSettings.put(SAVE_PASSWORD, Boolean.toString(savePassword));
                this.hostSettingsMap.put(host, hostSettings);
                if (savePassword && this.sshSettings.getPassword() != null && this.sshSettings.getPassword().length() != 0) {
                    this.saveSecurePassword(host, this.sshSettings.getPassword());
                }
            }
        }
    }

    private void saveSecurePassword(String host, String password) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)password);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            try {
                node.put("password", password, true);
            }
            catch (StorageException storageException) {}
        }
    }

    private String accessSecurePassword(String host) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            String password = null;
            try {
                password = node.get("password", null);
            }
            catch (StorageException storageException) {}
            return password;
        }
        return null;
    }

    protected void removeSecurePassword(String host) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            node.remove("password");
        }
    }

    public boolean isValid() {
        return this.isEncodingValid() && this.sshSettingsPage.validateSettings();
    }

    protected String getHostFromSettings() {
        this.sshSettingsPage.saveSettings();
        return this.sshSettings.getHost();
    }

    private void createPasswordUI(Composite parent, boolean separator) {
        Assert.isNotNull((Object)parent);
        if (separator) {
            Label sep = new Label(parent, 258);
            sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.passwordButton = new Button(panel, 32);
        this.passwordButton.setLayoutData((Object)new GridData(4, 131072, true, false));
        this.passwordButton.setText(Messages.SshWizardConfigurationPanel_savePasword);
    }
}

