/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.launcher;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LauncherDelegateManager
extends AbstractExtensionPointManager<ILauncherDelegate> {
    public static LauncherDelegateManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    LauncherDelegateManager() {
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.ui.terminals.launcherDelegates";
    }

    protected String getConfigurationElementName() {
        return "delegate";
    }

    public ILauncherDelegate[] getLauncherDelegates(boolean unique) {
        ArrayList<ILauncherDelegate> contributions = new ArrayList<ILauncherDelegate>();
        Collection launcherDelegates = this.getExtensions().values();
        for (ExecutableExtensionProxy launcherDelegate : launcherDelegates) {
            ILauncherDelegate instance;
            ILauncherDelegate iLauncherDelegate = instance = unique ? (ILauncherDelegate)launcherDelegate.newInstance() : (ILauncherDelegate)launcherDelegate.getInstance();
            if (instance == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new ILauncherDelegate[contributions.size()]);
    }

    public ILauncherDelegate getLauncherDelegate(String id, boolean unique) {
        ILauncherDelegate contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = unique ? (ILauncherDelegate)proxy.newInstance() : (ILauncherDelegate)proxy.getInstance();
        }
        return contribution;
    }

    public ILauncherDelegate[] getApplicableLauncherDelegates(ISelection selection) {
        ArrayList<ILauncherDelegate> applicable = new ArrayList<ILauncherDelegate>();
        ILauncherDelegate[] iLauncherDelegateArray = this.getLauncherDelegates(false);
        int n = iLauncherDelegateArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isApplicable;
            ILauncherDelegate delegate = iLauncherDelegateArray[n2];
            Expression enablement = delegate.getEnablement();
            boolean bl = isApplicable = enablement == null;
            if (enablement != null) {
                if (selection != null) {
                    IEvaluationContext currentState = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).getCurrentState();
                    EvaluationContext context = new EvaluationContext(currentState, (Object)selection);
                    context.addVariable("selection", (Object)selection);
                    context.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(delegate);
            }
            ++n2;
        }
        return applicable.toArray(new ILauncherDelegate[applicable.size()]);
    }

    private static class LazyInstanceHolder {
        public static LauncherDelegateManager instance = new LauncherDelegateManager();

        private LazyInstanceHolder() {
        }
    }
}

