/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.panels;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.panels.AbstractWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.WorkbenchEncoding;

public abstract class AbstractConfigurationPanel
extends AbstractWizardConfigurationPanel
implements IConfigurationPanel {
    private static final String LAST_HOST_TAG = "lastHost";
    private static final String HOSTS_TAG = "hosts";
    private static final String ENCODINGS_TAG = "encodings";
    Combo hostCombo;
    private Button deleteHostButton;
    Combo encodingCombo;
    String lastSelectedEncoding;
    final List<String> encodingHistory = new ArrayList<String>();
    private ISelection selection;
    protected final Map<String, Map<String, String>> hostSettingsMap = new HashMap<String, Map<String, String>>();

    public AbstractConfigurationPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    @Override
    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    @Override
    public ISelection getSelection() {
        return this.selection;
    }

    public String getSelectionHost() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Map props;
            Object element = ((IStructuredSelection)selection).getFirstElement();
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(element, IPropertiesAccessService.class);
            if (service != null && (props = service.getTargetAddress(element)) != null && props.containsKey("address")) {
                return (String)props.get("address");
            }
        }
        return null;
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        String[] hosts = settings.getArray(HOSTS_TAG);
        if (hosts != null) {
            int i = 0;
            while (i < hosts.length) {
                String hostEntry = hosts[i];
                String[] hostString = hostEntry.split("\\|");
                String hostName = hostString[0];
                if (hostString.length == 2) {
                    HashMap<String, String> attr = this.deSerialize(hostString[1]);
                    this.hostSettingsMap.put(hostName, attr);
                } else {
                    this.hostSettingsMap.put(hostName, new HashMap());
                }
                ++i;
            }
        }
        if (!this.isWithoutSelection()) {
            String host = this.getSelectionHost();
            if (host != null) {
                this.fillSettingsForHost(host);
            }
        } else if (this.hostCombo != null) {
            this.fillHostCombo();
            String lastHost = settings.get(LAST_HOST_TAG);
            if (lastHost != null) {
                int index = this.hostCombo.indexOf(lastHost);
                if (index != -1) {
                    this.hostCombo.select(index);
                } else {
                    this.hostCombo.select(0);
                }
            } else {
                this.hostCombo.select(0);
            }
            this.fillSettingsForHost(this.hostCombo.getText());
        }
        this.encodingHistory.clear();
        String[] encodings = settings.getArray(ENCODINGS_TAG);
        if (encodings != null && encodings.length > 0) {
            this.encodingHistory.addAll(Arrays.asList(encodings));
            for (String encoding : this.encodingHistory) {
                SWTControlUtil.add((Control)this.encodingCombo, (String)encoding, (int)(SWTControlUtil.getItemCount((Control)this.encodingCombo) - 1));
            }
        }
    }

    private HashMap<String, String> deSerialize(String hostString) {
        Assert.isNotNull((Object)hostString);
        HashMap<String, String> attr = new HashMap<String, String>();
        if (hostString.length() != 0) {
            String[] hostAttrs = hostString.split("\\:");
            int j = 0;
            while (j < hostAttrs.length) {
                String key = hostAttrs[j];
                String value = hostAttrs[j + 1];
                attr.put(key, value);
                j += 2;
            }
        }
        return attr;
    }

    private void serialize(Map<String, String> hostEntry, StringBuilder hostString) {
        Assert.isNotNull(hostEntry);
        Assert.isNotNull((Object)hostString);
        if (hostEntry.keySet().size() != 0) {
            for (Map.Entry<String, String> entry : hostEntry.entrySet()) {
                String attrKey = entry.getKey();
                String attrValue = entry.getValue();
                hostString.append(String.valueOf(attrKey) + ":" + attrValue + ":");
            }
            hostString.deleteCharAt(hostString.length() - 1);
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        String host;
        Iterator<String> nextHost = this.hostSettingsMap.keySet().iterator();
        String[] hosts = new String[this.hostSettingsMap.keySet().size()];
        int i = 0;
        while (nextHost.hasNext()) {
            StringBuilder hostString = new StringBuilder();
            String host2 = nextHost.next();
            hostString.append(String.valueOf(host2) + "|");
            Map<String, String> hostEntry = this.hostSettingsMap.get(host2);
            this.serialize(hostEntry, hostString);
            hosts[i] = hostString.toString();
            ++i;
        }
        settings.put(HOSTS_TAG, hosts);
        if (this.isWithoutSelection() && this.hostCombo != null && (host = this.getHostFromSettings()) != null) {
            settings.put(LAST_HOST_TAG, host);
        }
        if (!this.encodingHistory.isEmpty()) {
            settings.put(ENCODINGS_TAG, this.encodingHistory.toArray(new String[this.encodingHistory.size()]));
        }
    }

    protected abstract void saveSettingsForHost(boolean var1);

    protected abstract void fillSettingsForHost(String var1);

    protected abstract String getHostFromSettings();

    protected void removeSecurePassword(String host) {
    }

    protected final String getHostFromCombo() {
        return SWTControlUtil.getText((Control)this.hostCombo);
    }

    protected void removeSettingsForHost(String host) {
        if (this.hostSettingsMap.containsKey(host)) {
            this.hostSettingsMap.remove(host);
        }
    }

    private List<String> getHostList() {
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.addAll(this.hostSettingsMap.keySet());
        return hostList;
    }

    protected void fillHostCombo() {
        if (this.hostCombo != null) {
            this.hostCombo.removeAll();
            List<String> hostList = this.getHostList();
            Collections.sort(hostList);
            for (String host : hostList) {
                this.hostCombo.add(host);
            }
            if (hostList.size() <= 1) {
                this.hostCombo.setEnabled(false);
            } else {
                this.hostCombo.setEnabled(true);
            }
            if (this.deleteHostButton != null) {
                if (hostList.size() == 0) {
                    this.deleteHostButton.setEnabled(false);
                } else {
                    this.deleteHostButton.setEnabled(true);
                }
            }
        }
    }

    public boolean isWithoutSelection() {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return true;
        }
        return selection instanceof IStructuredSelection && selection.isEmpty();
    }

    public boolean isWithHostList() {
        return true;
    }

    protected void createHostsUI(Composite parent, boolean separator) {
        Assert.isNotNull((Object)parent);
        if (this.isWithoutSelection() && this.isWithHostList()) {
            Composite comboComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comboComposite.setLayout((Layout)layout);
            comboComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label = new Label(comboComposite, 256);
            label.setText(Messages.AbstractConfigurationPanel_hosts);
            this.hostCombo = new Combo(comboComposite, 8);
            this.hostCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.hostCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String host = SWTControlUtil.getText((Control)AbstractConfigurationPanel.this.hostCombo);
                    AbstractConfigurationPanel.this.fillSettingsForHost(host);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.deleteHostButton = new Button(comboComposite, 0);
            ISharedImages workbenchImages = UIPlugin.getDefault().getWorkbench().getSharedImages();
            this.deleteHostButton.setImage(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE").createImage());
            this.deleteHostButton.setToolTipText(Messages.AbstractConfigurationPanel_deleteButtonTooltip);
            this.deleteHostButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String host = AbstractConfigurationPanel.this.getHostFromCombo();
                    if (host != null && host.length() != 0) {
                        AbstractConfigurationPanel.this.removeSettingsForHost(host);
                        AbstractConfigurationPanel.this.removeSecurePassword(host);
                        AbstractConfigurationPanel.this.fillHostCombo();
                        SWTControlUtil.select((Control)AbstractConfigurationPanel.this.hostCombo, (int)0);
                        host = AbstractConfigurationPanel.this.getHostFromCombo();
                        if (host != null && host.length() != 0) {
                            AbstractConfigurationPanel.this.fillSettingsForHost(host);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            if (separator) {
                Label sep = new Label(parent, 258);
                sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            }
        }
    }

    protected void createEncodingUI(final Composite parent, boolean separator) {
        Assert.isNotNull((Object)parent);
        if (separator) {
            Label sep = new Label(parent, 258);
            sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(panel, 256);
        label.setText(Messages.AbstractConfigurationPanel_encoding);
        this.encodingCombo = new Combo(panel, 8);
        this.encodingCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Messages.AbstractConfigurationPanel_encoding_custom.equals(SWTControlUtil.getText((Control)AbstractConfigurationPanel.this.encodingCombo))) {
                    InputDialog dialog = new InputDialog(parent.getShell(), Messages.AbstractConfigurationPanel_encoding_custom_title, Messages.AbstractConfigurationPanel_encoding_custom_message, null, new IInputValidator(){

                        public String isValid(String newText) {
                            boolean valid = false;
                            try {
                                if (newText != null && !"".equals(newText)) {
                                    valid = Charset.isSupported(newText);
                                }
                            }
                            catch (IllegalCharsetNameException illegalCharsetNameException) {}
                            if (!valid) {
                                return newText != null && !"".equals(newText) ? Messages.AbstractConfigurationPanel_encoding_custom_error : "";
                            }
                            return null;
                        }
                    });
                    if (dialog.open() == 0) {
                        String encoding = dialog.getValue();
                        SWTControlUtil.add((Control)AbstractConfigurationPanel.this.encodingCombo, (String)encoding, (int)(SWTControlUtil.getItemCount((Control)AbstractConfigurationPanel.this.encodingCombo) - 1));
                        SWTControlUtil.select((Control)AbstractConfigurationPanel.this.encodingCombo, (int)SWTControlUtil.indexOf((Control)AbstractConfigurationPanel.this.encodingCombo, (String)encoding));
                        AbstractConfigurationPanel.this.lastSelectedEncoding = SWTControlUtil.getText((Control)AbstractConfigurationPanel.this.encodingCombo);
                        if (!AbstractConfigurationPanel.this.encodingHistory.contains(encoding)) {
                            if (AbstractConfigurationPanel.this.encodingHistory.size() == 5) {
                                AbstractConfigurationPanel.this.encodingHistory.remove(4);
                            }
                            AbstractConfigurationPanel.this.encodingHistory.add(encoding);
                        }
                    } else {
                        SWTControlUtil.select((Control)AbstractConfigurationPanel.this.encodingCombo, (int)SWTControlUtil.indexOf((Control)AbstractConfigurationPanel.this.encodingCombo, (String)AbstractConfigurationPanel.this.lastSelectedEncoding));
                    }
                }
            }
        });
        this.fillEncodingCombo();
    }

    protected void fillEncodingCombo() {
        if (this.encodingCombo != null) {
            String hostEncoding;
            ArrayList<String> encodings = new ArrayList<String>();
            encodings.add("Default (ISO-8859-1)");
            encodings.add("UTF-8");
            String eclipseEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (eclipseEncoding != null && !encodings.contains(eclipseEncoding)) {
                encodings.add(eclipseEncoding);
            }
            if (!encodings.contains(hostEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding())) {
                encodings.add(hostEncoding);
            }
            encodings.add(Messages.AbstractConfigurationPanel_encoding_custom);
            SWTControlUtil.setItems((Control)this.encodingCombo, (String[])encodings.toArray(new String[encodings.size()]));
            SWTControlUtil.select((Control)this.encodingCombo, (int)0);
            this.lastSelectedEncoding = SWTControlUtil.getText((Control)this.encodingCombo);
        }
    }

    protected void setEncoding(String encoding) {
        Assert.isNotNull((Object)encoding);
        int index = SWTControlUtil.indexOf((Control)this.encodingCombo, (String)("ISO-8859-1".equals(encoding) ? "Default (ISO-8859-1)" : encoding));
        if (index != -1) {
            SWTControlUtil.select((Control)this.encodingCombo, (int)index);
        } else {
            SWTControlUtil.setText((Control)this.encodingCombo, (String)encoding);
        }
    }

    protected String getEncoding() {
        String encoding = SWTControlUtil.getText((Control)this.encodingCombo);
        return encoding != null && encoding.startsWith("Default") ? null : encoding;
    }

    protected boolean isEncodingValid() {
        try {
            String encoding = this.getEncoding();
            return Charset.isSupported(encoding != null ? encoding : "ISO-8859-1");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }
}

