/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.streams;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.services.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;

public class OutputStreamMonitor
implements IDisposable {
    private static final int BUFFER_SIZE = 8192;
    private final ITerminalControl terminalControl;
    private final InputStream stream;
    private final String lineSeparator;
    private Thread thread;
    private boolean disposed;
    private final List<IDisposable> disposables = new ArrayList<IDisposable>();
    private final ListenerList listeners;

    public OutputStreamMonitor(ITerminalControl terminalControl, InputStream stream, String lineSeparator) {
        Assert.isNotNull((Object)terminalControl);
        this.terminalControl = terminalControl;
        Assert.isNotNull((Object)stream);
        this.stream = new BufferedInputStream(stream, 8192);
        this.lineSeparator = lineSeparator;
        this.listeners = new ListenerList();
    }

    public final void addListener(ITerminalServiceOutputStreamMonitorListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    public final void removeListener(ITerminalServiceOutputStreamMonitorListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    public final void addDisposable(IDisposable disposable) {
        Assert.isNotNull((Object)disposable);
        if (!this.disposed && !this.disposables.contains(disposable)) {
            this.disposables.add(disposable);
        }
    }

    public final void removeDisposable(IDisposable disposable) {
        Assert.isNotNull((Object)disposable);
        this.disposables.remove(disposable);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.stream.close();
        }
        catch (IOException iOException) {}
        for (IDisposable disposable : this.disposables) {
            disposable.dispose();
        }
        this.disposables.clear();
    }

    protected void startMonitoring() {
        if (this.thread != null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OutputStreamMonitor.this.readStream();
            }
        };
        this.thread = new Thread(runnable, "Terminal Output Stream Monitor Thread");
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.start();
    }

    protected ITerminalControl getTerminalControl() {
        return this.terminalControl;
    }

    void readStream() {
        byte[] readBuffer = new byte[8192];
        long sleepMarker = System.currentTimeMillis();
        int read = 0;
        while (read >= 0 && !this.disposed) {
            block7: {
                try {
                    read = this.stream.read(readBuffer);
                    if (read <= 0) break block7;
                    byte[] processedReadBuffer = this.onContentReadFromStream(readBuffer, read);
                    if (processedReadBuffer != readBuffer) {
                        read = processedReadBuffer.length;
                    }
                    this.terminalControl.getRemoteToTerminalOutputStream().write(processedReadBuffer, 0, read);
                }
                catch (IOException e) {
                    if (this.disposed) break;
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OutputStreamMonitor_error_readingFromStream, (Object)e.getLocalizedMessage()), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                    break;
                }
                catch (NullPointerException e) {
                    if (this.disposed || this.thread == null) break;
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OutputStreamMonitor_error_readingFromStream, (Object)e.getLocalizedMessage()), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                    break;
                }
            }
            if (System.currentTimeMillis() - sleepMarker <= 1000L) continue;
            sleepMarker = System.currentTimeMillis();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.dispose();
    }

    protected byte[] onContentReadFromStream(byte[] byteBuffer, int bytesRead) {
        Assert.isNotNull((Object)byteBuffer);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/outputStreamMonitor")) {
            StringBuilder debug = new StringBuilder("byteBuffer [decimal, " + bytesRead + " bytes] : ");
            int i = 0;
            while (i < bytesRead) {
                debug.append(Byte.valueOf(byteBuffer[i]).intValue());
                debug.append(' ');
                ++i;
            }
            System.out.println(debug.toString());
        }
        boolean changed = false;
        String text = new String(byteBuffer, 0, bytesRead);
        if (text.indexOf(14) != -1 || text.indexOf(15) != -1) {
            text = text.replaceAll("\\x0e", "").replaceAll("\\x0f", "");
            changed = true;
        }
        if (this.lineSeparator != null && !"\\r\\n".equals(this.lineSeparator)) {
            String separator2;
            String separator = "\\n".equals(this.lineSeparator) ? "\n" : "\r";
            String string = separator2 = "\\n".equals(this.lineSeparator) ? "\r" : "\n";
            if (text.indexOf(separator) != -1) {
                String[] fragments = text.split(separator);
                StringBuilder b = new StringBuilder();
                int i = 0;
                while (i < fragments.length) {
                    String fragment = fragments[i];
                    String nextFragment = i + 1 < fragments.length ? fragments[i + 1] : null;
                    b.append(fragment);
                    if (fragment.endsWith(separator2) || nextFragment != null && nextFragment.startsWith(separator2)) {
                        b.append(separator);
                    } else {
                        b.append("\n\r");
                    }
                    ++i;
                }
                if (!text.equals(b.toString())) {
                    text = b.toString();
                    changed = true;
                }
            }
        }
        if (changed) {
            byteBuffer = text.getBytes();
            bytesRead = byteBuffer.length;
        }
        if (this.listeners.size() > 0) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object candidate = objectArray[n2];
                if (candidate instanceof ITerminalServiceOutputStreamMonitorListener) {
                    ((ITerminalServiceOutputStreamMonitorListener)candidate).onContentReadFromStream(byteBuffer, bytesRead);
                }
                ++n2;
            }
        }
        return byteBuffer;
    }
}

