/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.ui.WorkbenchPartControl;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.interfaces.ITreeControlInputChangedListener;
import org.eclipse.tcf.te.ui.trees.CollapseAllAction;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.ConfigFilterAction;
import org.eclipse.tcf.te.ui.trees.ContentDescriptor;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.TreeControlSorter;
import org.eclipse.tcf.te.ui.trees.TreeViewerDelegatingContentProvider;
import org.eclipse.tcf.te.ui.trees.TreeViewerEditorActivationStrategy;
import org.eclipse.tcf.te.ui.trees.TreeViewerExtension;
import org.eclipse.tcf.te.ui.trees.TreeViewerHeaderMenu;
import org.eclipse.tcf.te.ui.trees.TreeViewerLabelProvider;
import org.eclipse.tcf.te.ui.trees.TreeViewerState;
import org.eclipse.tcf.te.ui.trees.ViewerStateManager;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractTreeControl
extends WorkbenchPartControl
implements SelectionListener {
    private TreeViewer viewer;
    private ISelectionChangedListener selectionChangedListener;
    private FilterDescriptor[] filterDescriptors;
    private ColumnDescriptor[] columnDescriptors;
    private ContentDescriptor[] contentDescriptors;
    private TreeViewerState viewerState;
    private ConfigFilterAction configFilterAction;
    private MenuManager manager;
    private final ListenerList inputChangedListeners = new ListenerList();

    public AbstractTreeControl() {
    }

    public AbstractTreeControl(IWorkbenchPart parent) {
        super(parent);
    }

    @Override
    public void dispose() {
        this.saveViewerState();
        if (this.selectionChangedListener != null) {
            if (this.getViewer() != null) {
                this.getViewer().removeSelectionChangedListener(this.selectionChangedListener);
            }
            this.selectionChangedListener = null;
        }
        this.disposeDescriptors();
        this.inputChangedListeners.clear();
        super.dispose();
    }

    protected void disposeDescriptors() {
        int n;
        int n2;
        Object[] objectArray;
        if (this.columnDescriptors != null) {
            objectArray = this.columnDescriptors;
            n2 = this.columnDescriptors.length;
            n = 0;
            while (n < n2) {
                Object column = objectArray[n];
                if (((ColumnDescriptor)column).getImage() != null) {
                    ((ColumnDescriptor)column).getImage().dispose();
                }
                if (((ColumnDescriptor)column).getLabelProvider() != null) {
                    ((ColumnDescriptor)column).getLabelProvider().dispose();
                }
                if (((ColumnDescriptor)column).getTreeColumn() != null) {
                    ((ColumnDescriptor)column).getTreeColumn().dispose();
                }
                ++n;
            }
            this.columnDescriptors = null;
        }
        if (this.filterDescriptors != null) {
            objectArray = this.filterDescriptors;
            n2 = this.filterDescriptors.length;
            n = 0;
            while (n < n2) {
                Object filterDescriptor = objectArray[n];
                if (((FilterDescriptor)filterDescriptor).getImage() != null) {
                    ((FilterDescriptor)filterDescriptor).getImage().dispose();
                }
                ++n;
            }
            this.filterDescriptors = null;
        }
        if (this.contentDescriptors != null) {
            objectArray = this.contentDescriptors;
            n2 = this.contentDescriptors.length;
            n = 0;
            while (n < n2) {
                Object contentDescriptor = objectArray[n];
                ((ContentDescriptor)contentDescriptor).dispose();
                ++n;
            }
            this.contentDescriptors = null;
        }
    }

    @Override
    public void setupFormPanel(Composite parent, CustomFormToolkit toolkit) {
        super.setupFormPanel(parent, toolkit);
        this.viewer = this.doCreateTreeViewer(parent);
        this.doConfigureTreeViewer(this.viewer);
        this.doCreateContributionItems(this.viewer);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        return new TreeViewer(parent, 65540);
    }

    protected void doConfigureTreeViewer(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        viewer.setAutoExpandLevel(this.getAutoExpandLevel());
        viewer.setLabelProvider((IBaseLabelProvider)this.doCreateTreeViewerLabelProvider(this, viewer));
        ITreeContentProvider mainContentProvider = this.doCreateTreeViewerContentProvider(viewer);
        Assert.isNotNull((Object)mainContentProvider);
        final TreeViewerDelegatingContentProvider contentProvider = new TreeViewerDelegatingContentProvider(this, mainContentProvider);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("inputChanged")) {
                    Object oldInput = args[1];
                    Object newInput = args[2];
                    if (oldInput == null && newInput != null || oldInput != null && newInput == null || oldInput != null && !oldInput.equals(newInput)) {
                        AbstractTreeControl.this.onInputChanged(oldInput, newInput);
                    }
                }
                return method.invoke((Object)contentProvider, args);
            }
        };
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Class[] interfaces = new Class[]{ITreeContentProvider.class};
        ITreeContentProvider proxy = (ITreeContentProvider)Proxy.newProxyInstance(classLoader, interfaces, handler);
        viewer.setContentProvider((IContentProvider)proxy);
        viewer.setComparator(this.doCreateTreeViewerComparator(this, viewer));
        viewer.getTree().setLayoutData(this.doCreateTreeViewerLayoutData(viewer));
        this.selectionChangedListener = this.doCreateTreeViewerSelectionChangedListener(viewer);
        if (this.selectionChangedListener != null) {
            viewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        TreeViewerEditorActivationStrategy activationStrategy = new TreeViewerEditorActivationStrategy(this.getViewerId(), viewer);
        TreeViewerEditor.create((TreeViewer)viewer, null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)1);
    }

    protected void onInputChanged(Object oldInput, Object newInput) {
        Object[] listeners;
        if (newInput != null) {
            this.disposeDescriptors();
            this.columnDescriptors = this.doCreateViewerColumns(newInput);
            this.filterDescriptors = this.doCreateFilterDescriptors(newInput);
            this.contentDescriptors = this.doCreateContentDescriptors(newInput);
            if (this.isStatePersistent()) {
                this.updateViewerState(newInput);
            }
            this.doCreateTreeColumns(this.viewer);
            this.viewer.getTree().setHeaderVisible(true);
            this.updateFilters();
            this.createHeaderMenu(this).create();
            if (this.configFilterAction != null) {
                this.configFilterAction.updateEnablement();
            }
        }
        Object[] objectArray = listeners = this.inputChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object candidate = objectArray[n2];
            if (candidate instanceof ITreeControlInputChangedListener) {
                ((ITreeControlInputChangedListener)candidate).inputChanged(this, oldInput, newInput);
            }
            ++n2;
        }
    }

    protected TreeViewerHeaderMenu createHeaderMenu(AbstractTreeControl control) {
        Assert.isNotNull((Object)((Object)control));
        return new TreeViewerHeaderMenu(control);
    }

    private void updateViewerState(Object newInput) {
        String inputId;
        IViewerInput viewerInput = ViewerStateManager.getViewerInput(newInput);
        if (viewerInput != null && (inputId = viewerInput.getInputId()) != null) {
            inputId = String.valueOf(this.getViewerId()) + "." + inputId;
            this.viewerState = ViewerStateManager.getInstance().getViewerState(inputId);
            if (this.viewerState == null) {
                this.viewerState = ViewerStateManager.createViewerState(this.columnDescriptors, this.filterDescriptors);
                ViewerStateManager.getInstance().putViewerState(inputId, this.viewerState);
            } else {
                this.viewerState.updateColumnDescriptor(this.columnDescriptors);
                this.viewerState.updateFilterDescriptor(this.filterDescriptors);
            }
        }
    }

    private void saveViewerState() {
        if (this.isStatePersistent() && this.viewerState != null) {
            this.viewerState.updateColumnState(this.columnDescriptors);
            this.viewerState.updateFilterState(this.filterDescriptors);
        }
    }

    void updateFilterState() {
        if (this.isStatePersistent() && this.viewerState != null) {
            this.viewerState.updateFilterState(this.filterDescriptors);
        }
    }

    boolean setColumnVisible(ColumnDescriptor column, boolean visible) {
        if (column.isVisible() && !visible) {
            TreeColumn treeColumn = column.getTreeColumn();
            treeColumn.dispose();
            column.setTreeColumn(null);
            column.setVisible(visible);
            return true;
        }
        if (!column.isVisible() && visible) {
            TreeColumn treeColumn = this.doCreateTreeColumn(column, false);
            column.setTreeColumn(treeColumn);
            column.setVisible(visible);
            return true;
        }
        return false;
    }

    protected boolean isStatePersistent() {
        return true;
    }

    protected ColumnDescriptor[] doCreateViewerColumns(Object newInput) {
        if (this.columnDescriptors == null) {
            TreeViewerExtension viewerExtension = new TreeViewerExtension(this.getViewerId());
            this.columnDescriptors = viewerExtension.parseColumns(newInput);
        }
        return this.columnDescriptors;
    }

    protected FilterDescriptor[] doCreateFilterDescriptors(Object newInput) {
        if (this.filterDescriptors == null) {
            TreeViewerExtension viewerExtension = new TreeViewerExtension(this.getViewerId());
            this.filterDescriptors = viewerExtension.parseFilters(newInput);
        }
        return this.filterDescriptors;
    }

    protected ContentDescriptor[] doCreateContentDescriptors(Object newInput) {
        if (this.contentDescriptors == null) {
            TreeViewerExtension viewerExtension = new TreeViewerExtension(this.getViewerId());
            this.contentDescriptors = viewerExtension.parseContents(newInput);
        }
        return this.contentDescriptors;
    }

    public ContentDescriptor[] getContentDescriptors() {
        return this.contentDescriptors;
    }

    public void updateFilters() {
        if (this.filterDescriptors != null) {
            ArrayList<ViewerFilter> newFilters = new ArrayList<ViewerFilter>();
            FilterDescriptor[] filterDescriptorArray = this.filterDescriptors;
            int n = this.filterDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                FilterDescriptor descriptor = filterDescriptorArray[n2];
                if (descriptor.getFilter() != null && descriptor.isEnabled()) {
                    newFilters.add(descriptor.getFilter());
                }
                ++n2;
            }
            this.viewer.setFilters(newFilters.toArray(new ViewerFilter[newFilters.size()]));
        }
    }

    protected void doCreateTreeColumns(TreeViewer viewer) {
        Assert.isTrue((this.columnDescriptors != null && this.columnDescriptors.length > 0 ? 1 : 0) != 0);
        ArrayList<ColumnDescriptor> visibleColumns = new ArrayList<ColumnDescriptor>();
        ColumnDescriptor[] columnDescriptorArray = this.columnDescriptors;
        int n = this.columnDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor column = columnDescriptorArray[n2];
            if (column.isVisible()) {
                visibleColumns.add(column);
            }
            ++n2;
        }
        Collections.sort(visibleColumns, new Comparator<ColumnDescriptor>(){

            @Override
            public int compare(ColumnDescriptor o1, ColumnDescriptor o2) {
                return o1.getOrder() < o2.getOrder() ? -1 : (o1.getOrder() > o2.getOrder() ? 1 : 0);
            }
        });
        for (ColumnDescriptor visibleColumn : visibleColumns) {
            this.doCreateTreeColumn(visibleColumn, true);
        }
        Assert.isTrue((viewer.getTree().getColumnCount() > 0 ? 1 : 0) != 0);
        TreeColumn treeColumn = viewer.getTree().getColumn(0);
        ColumnDescriptor column = (ColumnDescriptor)treeColumn.getData();
        if (column != null) {
            viewer.getTree().setSortColumn(treeColumn);
            viewer.getTree().setSortDirection(column.isAscending() ? 128 : 1024);
        }
    }

    protected TreeColumn doCreateTreeColumn(final ColumnDescriptor column, boolean append) {
        Tree tree = this.viewer.getTree();
        final TreeColumn treeColumn = append ? new TreeColumn(tree, column.getStyle()) : new TreeColumn(tree, column.getStyle(), this.getColumnIndex(column));
        treeColumn.setData((Object)column);
        treeColumn.setText(column.getName());
        treeColumn.setToolTipText(column.getDescription());
        treeColumn.setAlignment(column.getAlignment());
        treeColumn.setImage(column.getImage());
        treeColumn.setMoveable(column.isMoveable());
        treeColumn.setResizable(column.isResizable());
        treeColumn.setData("widthHint", (Object)column.getWidth());
        treeColumn.setWidth(column.getWidth());
        treeColumn.addSelectionListener((SelectionListener)this);
        treeColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                AbstractTreeControl.this.columnMoved();
            }

            public void controlResized(ControlEvent e) {
                column.setWidth(treeColumn.getWidth());
            }
        });
        column.setTreeColumn(treeColumn);
        this.configureTreeColumn(treeColumn);
        return treeColumn;
    }

    protected void configureTreeColumn(TreeColumn treeColumn) {
        Assert.isNotNull((Object)treeColumn);
    }

    protected void columnMoved() {
        Tree tree = this.viewer.getTree();
        TreeColumn[] treeColumns = tree.getColumns();
        if (treeColumns != null && treeColumns.length > 0) {
            int[] orders = tree.getColumnOrder();
            int i = 0;
            while (i < orders.length) {
                TreeColumn treeColumn = treeColumns[orders[i]];
                ColumnDescriptor column = (ColumnDescriptor)treeColumn.getData();
                if (column != null) {
                    column.setOrder(i);
                }
                ++i;
            }
        }
    }

    private int getColumnIndex(ColumnDescriptor column) {
        Assert.isTrue((this.columnDescriptors != null ? 1 : 0) != 0);
        int visibleCount = 0;
        int i = 0;
        while (i < this.columnDescriptors.length) {
            if (this.columnDescriptors[i] == column) break;
            if (this.columnDescriptors[i].isVisible()) {
                ++visibleCount;
            }
            ++i;
        }
        return visibleCount;
    }

    protected abstract String getViewerId();

    protected int getAutoExpandLevel() {
        return 2;
    }

    protected Object doCreateTreeViewerLayoutData(TreeViewer viewer) {
        GridData data = new GridData(1808);
        data.widthHint = 0;
        data.heightHint = 0;
        return data;
    }

    protected ILabelProvider doCreateTreeViewerLabelProvider(AbstractTreeControl parentTreeControl, TreeViewer viewer) {
        TreeViewerLabelProvider labelProvider = new TreeViewerLabelProvider(parentTreeControl, viewer);
        return labelProvider;
    }

    protected abstract ITreeContentProvider doCreateTreeViewerContentProvider(TreeViewer var1);

    protected ViewerComparator doCreateTreeViewerComparator(AbstractTreeControl parentTreeControl, TreeViewer viewer) {
        Assert.isNotNull((Object)((Object)parentTreeControl));
        Assert.isNotNull((Object)viewer);
        return new TreeControlSorter(parentTreeControl);
    }

    protected abstract ISelectionChangedListener doCreateTreeViewerSelectionChangedListener(TreeViewer var1);

    protected void doCreateContributionItems(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.manager = new MenuManager("#PopupMenu");
        this.manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.manager.setRemoveAllWhenShown(true);
        viewer.getTree().setMenu(this.manager.createContextMenu((Control)viewer.getTree()));
    }

    public MenuManager getContextMenuManager() {
        return this.manager;
    }

    public void createToolbarContributionItems(IToolBarManager toolbarManager) {
        toolbarManager.insertAfter("group.additions.control", (IAction)new CollapseAllAction(this));
        this.configFilterAction = new ConfigFilterAction(this);
        toolbarManager.insertAfter("group.additions.control", (IAction)this.configFilterAction);
    }

    public FilterDescriptor[] getFilterDescriptors() {
        return this.filterDescriptors != null ? Arrays.copyOf(this.filterDescriptors, this.filterDescriptors.length) : new FilterDescriptor[]{};
    }

    public ColumnDescriptor[] getViewerColumns() {
        return this.columnDescriptors != null ? Arrays.copyOf(this.columnDescriptors, this.columnDescriptors.length) : new ColumnDescriptor[]{};
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (Viewer.class.isAssignableFrom(adapter)) {
            Viewer viewer = this.getViewer();
            if (!adapter.isAssignableFrom(viewer.getClass())) {
                viewer = null;
            }
            return viewer;
        }
        return super.getAdapter(adapter);
    }

    public void widgetSelected(SelectionEvent e) {
        Assert.isTrue((boolean)(e.getSource() instanceof TreeColumn));
        TreeColumn treeColumn = (TreeColumn)e.getSource();
        ColumnDescriptor column = (ColumnDescriptor)treeColumn.getData();
        if (column != null) {
            this.viewer.getTree().setSortColumn(treeColumn);
            column.setAscending(!column.isAscending());
            this.viewer.getTree().setSortDirection(column.isAscending() ? 128 : 1024);
            Object[] expandedElements = this.viewer.getExpandedElements();
            this.viewer.refresh();
            this.viewer.setExpandedElements(expandedElements);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public final void addInputChangedListener(ITreeControlInputChangedListener listener) {
        if (listener != null) {
            this.inputChangedListeners.add((Object)listener);
        }
    }

    public final void removeInputChangedListener(ITreeControlInputChangedListener listener) {
        if (listener != null) {
            this.inputChangedListeners.remove((Object)listener);
        }
    }
}

