/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractValidatingWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public abstract class AbstractWizard
extends Wizard
implements IWorkbenchWizard {
    private boolean dialogSettingsInitialized = false;
    private IWorkbench workbench = null;
    private IStructuredSelection selection = null;

    private final void initializeDialogSettings() {
        IDialogSettings rootSettings = this.getRootDialogSettings();
        IDialogSettings section = rootSettings.getSection(this.getWizardSectionName());
        if (section == null) {
            section = rootSettings.addNewSection(this.getWizardSectionName());
        }
        this.setDialogSettings(section);
        this.dialogSettingsInitialized = true;
    }

    protected IDialogSettings getRootDialogSettings() {
        return UIPlugin.getDefault().getDialogSettings();
    }

    protected String getWizardSectionName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IPropertiesContainer data = this.getInitialData();
        if (data == null) {
            data = new PropertiesContainer();
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IDataExchangeNode) {
                ((IDataExchangeNode)page).setupData(data);
                if (page instanceof AbstractValidatingWizardPage) {
                    ((AbstractValidatingWizardPage)page).validate();
                }
            }
            ++n2;
        }
    }

    protected IPropertiesContainer getInitialData() {
        return null;
    }

    public IDialogSettings getDialogSettings() {
        if (!this.dialogSettingsInitialized) {
            this.initializeDialogSettings();
        }
        return super.getDialogSettings();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public final IWorkbench getWorkbench() {
        return this.workbench;
    }

    public final IStructuredSelection getSelection() {
        return this.selection;
    }
}

