/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class ViewMemoryCommand
extends AbstractActionDelegate {
    private final Runnable on_value_changed = new Runnable(){

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewMemoryCommand.this.selectionChanged();
                }
            });
        }
    };

    private Block getBlockInfo(final TCFNode node) {
        try {
            return (Block)new TCFTask<Block>(node.getChannel()){

                public void run() {
                    try {
                        TCFModel model = node.getModel();
                        TCFNode mem_node = node;
                        BigInteger addr = null;
                        long size = -1L;
                        if (node instanceof TCFNodeExpression) {
                            TCFDataCache<IExpressions.Value> val_cache = ((TCFNodeExpression)node).getValue();
                            if (!val_cache.validate(ViewMemoryCommand.this.on_value_changed)) {
                                this.done(null);
                                return;
                            }
                            IExpressions.Value val_data = (IExpressions.Value)val_cache.getData();
                            if (val_data != null) {
                                List pieces;
                                byte[] bytes;
                                addr = JSON.toBigInteger((Number)val_data.getAddress());
                                if (addr != null && (bytes = val_data.getValue()) != null) {
                                    size = bytes.length;
                                }
                                if (addr == null) {
                                    String id = val_data.getRegisterID();
                                    if (val_data.getRegisterID() != null) {
                                        if (!model.createNode(id, (Runnable)((Object)this))) {
                                            return;
                                        }
                                        TCFNodeRegister reg_node = (TCFNodeRegister)model.getNode(id);
                                        if (reg_node != null) {
                                            String mem_id;
                                            Iterator reg_cache = reg_node.getContext();
                                            if (!reg_cache.validate((Runnable)((Object)this))) {
                                                return;
                                            }
                                            IRegisters.RegistersContext reg_data = (IRegisters.RegistersContext)reg_cache.getData();
                                            if (reg_data != null && (mem_id = reg_data.getMemoryContext()) != null) {
                                                if (!model.createNode(mem_id, (Runnable)((Object)this))) {
                                                    return;
                                                }
                                                addr = JSON.toBigInteger((Number)reg_data.getMemoryAddress());
                                                mem_node = model.getNode(mem_id);
                                            }
                                        }
                                    }
                                }
                                if (addr == null && (pieces = (List)val_data.getProperties().get("Pieces")) != null) {
                                    for (Map props : pieces) {
                                        addr = JSON.toBigInteger((Number)((Number)props.get("Address")));
                                        if (addr == null) continue;
                                        Number n = (Number)props.get("Size");
                                        if (n == null) break;
                                        size = n.longValue();
                                        break;
                                    }
                                }
                                if (addr == null && (bytes = val_data.getValue()) != null && bytes.length > 0) {
                                    addr = TCFNumberFormat.toBigInteger(bytes, val_data.isBigEndian(), false);
                                }
                            }
                        } else if (node instanceof TCFNodeRegister) {
                            TCFNodeRegister reg_node = (TCFNodeRegister)node;
                            TCFDataCache<IRegisters.RegistersContext> reg_cache = reg_node.getContext();
                            if (!reg_cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IRegisters.RegistersContext reg_data = (IRegisters.RegistersContext)reg_cache.getData();
                            if (reg_data != null) {
                                String mem_id = reg_data.getMemoryContext();
                                if (mem_id != null) {
                                    if (!model.createNode(mem_id, (Runnable)((Object)this))) {
                                        return;
                                    }
                                    addr = JSON.toBigInteger((Number)reg_data.getMemoryAddress());
                                    mem_node = model.getNode(mem_id);
                                }
                                if (addr == null) {
                                    TCFDataCache<byte[]> val_cache = reg_node.getValue();
                                    if (!val_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    byte[] bytes = (byte[])val_cache.getData();
                                    if (bytes != null && bytes.length > 0) {
                                        addr = TCFNumberFormat.toBigInteger(bytes, reg_data.isBigEndian(), false);
                                    }
                                }
                            }
                        }
                        Block b = null;
                        if (addr != null && mem_node != null) {
                            b = new Block();
                            b.node = mem_node;
                            b.addr = addr;
                            b.size = size;
                        }
                        this.done(b);
                    }
                    catch (Exception x) {
                        this.error(x);
                    }
                }
            }.get();
        }
        catch (Exception x) {
            if (node.getChannel().getState() != 1) {
                return null;
            }
            Activator.log("Cannot get memory address", x);
            return null;
        }
    }

    private void createRenderingInContainer(IViewPart view, IMemoryBlock mb, IMemoryRenderingType type, String pane) {
        try {
            if (view instanceof IMemoryRenderingSite) {
                IMemoryRendering rendering = type.createRendering();
                IMemoryRenderingContainer container = ((IMemoryRenderingSite)view).getContainer(pane);
                rendering.init(container, mb);
                container.addMemoryRendering(rendering);
            }
        }
        catch (CoreException x) {
            Activator.log(x);
        }
    }

    private void addDefaultRenderings(IViewPart view, IMemoryBlock memoryBlock) {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        IMemoryRenderingType primary_type = manager.getPrimaryRenderingType(memoryBlock);
        IMemoryRenderingType[] default_types = manager.getDefaultRenderingTypes(memoryBlock);
        if (primary_type != null) {
            this.createRenderingInContainer(view, memoryBlock, primary_type, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
        } else if (default_types.length > 0) {
            primary_type = default_types[0];
            this.createRenderingInContainer(view, memoryBlock, default_types[0], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
        }
        IMemoryRenderingType[] iMemoryRenderingTypeArray = default_types;
        int n = default_types.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            if (!primary_type.getId().equals(type.getId())) {
                this.createRenderingInContainer(view, memoryBlock, type, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
            }
            ++n2;
        }
    }

    @Override
    protected void run() {
        try {
            IWorkbenchPage page = this.getWindow().getActivePage();
            IViewPart view = page.showView("org.eclipse.debug.ui.MemoryView", null, 1);
            ArrayList<IMemoryBlock> list = new ArrayList<IMemoryBlock>();
            TCFNode[] tCFNodeArray = this.getSelectedNodes();
            int n = tCFNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryBlockRetrievalExtension mem_retrieval;
                TCFNode node = tCFNodeArray[n2];
                final Block b = this.getBlockInfo(node);
                if (b != null && (mem_retrieval = (IMemoryBlockRetrievalExtension)b.node.getAdapter(IMemoryBlockRetrievalExtension.class)) != null) {
                    list.add(mem_retrieval.getMemoryBlock(b.addr.longValue(), b.size));
                    new TCFTask<Boolean>(node.getChannel()){

                        public void run() {
                            for (TCFModelProxy p : b.node.getModel().getModelProxies()) {
                                IPresentationContext c = p.getPresentationContext();
                                if (c.getWindow() != ViewMemoryCommand.this.getWindow() || !"org.eclipse.debug.ui.DebugView".equals(c.getId())) continue;
                                p.setSelection(b.node);
                            }
                        }
                    };
                }
                ++n2;
            }
            IMemoryBlockManager manager = DebugPlugin.getDefault().getMemoryBlockManager();
            for (IMemoryBlock mb : list) {
                IMemoryBlock[] mb_array = new IMemoryBlock[]{mb};
                manager.addMemoryBlocks(mb_array);
                this.addDefaultRenderings(view, mb);
            }
        }
        catch (Exception x) {
            Activator.log("Cannot open memory view", x);
        }
    }

    @Override
    protected void selectionChanged() {
        int cnt = 0;
        TCFNode[] tCFNodeArray = this.getSelectedNodes();
        int n = tCFNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlockRetrievalExtension mem_retrieval;
            TCFNode node = tCFNodeArray[n2];
            Block b = this.getBlockInfo(node);
            if (b != null && (mem_retrieval = (IMemoryBlockRetrievalExtension)b.node.getAdapter(IMemoryBlockRetrievalExtension.class)) != null) {
                ++cnt;
            }
            ++n2;
        }
        this.setEnabled(cnt > 0);
    }

    private static class Block {
        TCFNode node;
        BigInteger addr;
        long size;

        private Block() {
        }
    }
}

