/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.channelmanager.OpenChannelException;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerNodeStep;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;

public class WaitForReadyStep
extends AbstractPeerNodeStep {
    public static final String PARAMETER_NO_TIMEOUT = "noTimeout";

    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
    }

    public void execute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        final IPeerNode peerNode = this.getActivePeerModelContext(context, data, fullQualifiedId);
        String param = (String)this.getParameters().get(PARAMETER_NO_TIMEOUT);
        boolean paramBool = false;
        if (param != null) {
            try {
                paramBool = Boolean.parseBoolean(param);
            }
            catch (Exception exception) {}
        }
        final boolean noTimeout = paramBool;
        if (peerNode != null && !Boolean.getBoolean("WaitForReadyStep.skip")) {
            Protocol.invokeLater((Runnable)new Runnable(){
                final Runnable thisRunnable = this;
                int totalWork;
                SimulatorUtils.Result result;
                final boolean isSimulatorRunning;
                int refreshCount;
                final AtomicReference<Throwable> lastError;
                {
                    this.totalWork = WaitForReadyStep.this.getTotalWork(iStepContext, iPropertiesContainer);
                    this.result = SimulatorUtils.getSimulatorService(WaitForReadyStep.this.getActivePeerModelContext(iStepContext, iPropertiesContainer, iFullQualifiedId));
                    this.isSimulatorRunning = this.result != null;
                    this.refreshCount = this.isSimulatorRunning ? 0 : this.totalWork - 1;
                    this.lastError = new AtomicReference();
                }

                @Override
                public void run() {
                    if (ProgressHelper.isCancel((Object)((Object)WaitForReadyStep.this), (IProgressMonitor)monitor, (ICallback)callback)) {
                        return;
                    }
                    if (!noTimeout && this.refreshCount >= this.totalWork) {
                        String message = NLS.bind((String)Messages.WaitForReadyStep_error_timeout, (Object)WaitForReadyStep.this.getActivePeerContext(context, data, fullQualifiedId).getName());
                        if (this.lastError.get() != null) {
                            String cause = this.lastError.get().getLocalizedMessage();
                            if (cause == null || "".equals(cause.trim())) {
                                cause = this.lastError.get().getClass().getName();
                            }
                            if (!cause.contains(this.lastError.get().getClass().getName())) {
                                cause = String.valueOf(cause) + " (" + this.lastError.get().getClass().getName() + ")";
                            }
                            message = String.valueOf(message) + NLS.bind((String)Messages.WaitForReadyStep_error_timeout_cause, (Object)cause);
                        }
                        WaitForReadyStep.this.callback(data, fullQualifiedId, callback, StatusHelper.getStatus((Throwable)new TimeoutException(message)), null);
                    } else {
                        Tcf.getChannelManager().openChannel(peerNode.getPeer(), null, new IChannelManager.DoneOpenChannel(){

                            public void doneOpenChannel(Throwable error, IChannel channel) {
                                if (ProgressHelper.isCancel((Object)((Object)WaitForReadyStep.this), (IProgressMonitor)monitor, (ICallback)callback)) {
                                    return;
                                }
                                Object exitError = peerNode.getProperty("ExitError");
                                if (exitError instanceof Throwable) {
                                    WaitForReadyStep.this.callback(data, fullQualifiedId, callback, StatusHelper.getStatus((Throwable)((Throwable)exitError)), null);
                                    return;
                                }
                                IStatus status = null;
                                if (error == null && channel != null && channel.getState() == 1) {
                                    StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)channel, (boolean)true);
                                    status = Status.OK_STATUS;
                                }
                                if (status != null && status.isOK()) {
                                    ArrayList<String> localServices = new ArrayList<String>(channel.getLocalServices());
                                    ArrayList<String> remoteServices = new ArrayList<String>(channel.getRemoteServices());
                                    Collections.sort(localServices);
                                    Collections.sort(remoteServices);
                                    IPeerModelUpdateService updateService = peerNode.getModel().getService(IPeerModelUpdateService.class);
                                    updateService.updatePeerServices(peerNode, localServices, remoteServices);
                                    channel.addChannelListener((IChannel.IChannelListener)peerNode);
                                    WaitForReadyStep.this.callback(data, fullQualifiedId, callback, status, null);
                                    return;
                                }
                                if (error != null && !(error instanceof OpenChannelException)) {
                                    WaitForReadyStep.this.callback(data, fullQualifiedId, callback, StatusHelper.getStatus((Throwable)error), null);
                                    return;
                                }
                                lastError.set(error instanceof OpenChannelException ? ((OpenChannelException)error).getError() : error);
                                ++refreshCount;
                                ProgressHelper.worked((IProgressMonitor)monitor, (int)1);
                                int delay = refreshCount < 20 ? 500 : 1000;
                                monitor.setTaskName(WaitForReadyStep.this.getLabel());
                                Protocol.invokeLater((long)delay, (Runnable)thisRunnable);
                            }
                        }, monitor);
                    }
                }
            });
        } else {
            this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
        }
    }

    public void rollback(final IStepContext context, final IPropertiesContainer data, final IStatus status, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        final IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        final IPeerNode peerNode = this.getActivePeerModelContext(context, data, fullQualifiedId);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                peerNode.setProperty("ExitError", null);
                Tcf.getChannelManager().shutdown(peer);
                WaitForReadyStep.super.rollback(context, data, status, fullQualifiedId, monitor, callback);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    public int getTotalWork(IStepContext context, IPropertiesContainer data) {
        return 100;
    }

    public int getCancelTimeout() {
        return 500;
    }
}

