/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.TCFEclipseFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;

public class TCFFileManager
implements IRemoteFileManager {
    private final TCFConnection fConnection;

    public TCFFileManager(TCFConnection connection) {
        this.fConnection = connection;
    }

    public String getDirectorySeparator() {
        return "/";
    }

    public IFileStore getResource(String pathStr) {
        if (!pathStr.startsWith("/")) {
            pathStr = String.valueOf(this.fConnection.getWorkingDirectory()) + "/" + pathStr;
        }
        return TCFFileStore.getInstance(this.fConnection, pathStr, null);
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        try {
            return TCFEclipseFileSystem.getURIFor(this.fConnection, path.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

