/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProcessesV1;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.remote.core.nls.Messages;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperation;

public class TCFOperationGetEnvironment
extends TCFOperation<Map<String, String>> {
    private final IPeer fPeer;

    public TCFOperationGetEnvironment(IPeer peer) {
        this.fPeer = peer;
    }

    @Override
    protected void doExecute() {
        IChannel channel = Tcf.getChannelManager().getChannel(this.fPeer);
        if (channel == null) {
            this.setError((IStatus)this.createStatus(MessageFormat.format(Messages.TCFOperationGetEnvironment_errorNoChannel, this.fPeer.getName()), null));
            return;
        }
        IProcesses psvc = (IProcesses)channel.getRemoteService(IProcessesV1.class);
        if (psvc == null) {
            psvc = (IProcesses)channel.getRemoteService(IProcesses.class);
        }
        if (psvc == null) {
            this.setError((IStatus)this.createStatus(MessageFormat.format(Messages.TCFOperationGetEnvironment_errorNoProcessesService, this.fPeer.getName()), null));
            return;
        }
        psvc.getEnvironment(new IProcesses.DoneGetEnvironment(){

            public void doneGetEnvironment(IToken token, Exception error, Map<String, String> environment) {
                if (TCFOperationGetEnvironment.this.shallAbort(error)) {
                    return;
                }
                TCFOperationGetEnvironment.this.setResult(environment);
            }
        });
    }
}

