/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.services;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapResolverService;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;

public class PathMapResolverService
extends AbstractService
implements IPathMapResolverService {
    @Override
    public String map(IPathMap.PathMapRule rule, String fnm) {
        Assert.isNotNull((Object)rule);
        Assert.isNotNull((Object)fnm);
        String fnmSlash = fnm.replaceAll("\\\\", "/");
        String src = rule.getSource();
        if (src == null) {
            return null;
        }
        String srcSlash = src.replaceAll("\\\\", "/");
        if (!fnmSlash.startsWith(srcSlash)) {
            return null;
        }
        String host = rule.getHost();
        if (host != null && host.length() > 0 && !IPAddressUtil.getInstance().isLocalHost(host)) {
            return null;
        }
        String dst = rule.getDestination();
        if (dst == null || dst.length() == 0) {
            return null;
        }
        int l = srcSlash.length();
        if (dst.endsWith("/") && l < fnmSlash.length() && fnmSlash.charAt(l) == '/') {
            ++l;
        }
        String fnmMapped = String.valueOf(dst) + fnmSlash.substring(l);
        return fnmMapped.replaceAll("\\\\", "/");
    }

    @Override
    public String findTargetPath(Object context, String hostPath) {
        IPathMap.PathMapRule[] rules;
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)hostPath);
        IPathMapService svc = (IPathMapService)ServiceManager.getInstance().getService(context, IPathMapService.class);
        if (svc != null && (rules = svc.getPathMap(context)) != null && rules.length > 0) {
            IPathMap.PathMapRule[] pathMapRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                String targetPath;
                String query;
                IPathMap.PathMapRule rule = pathMapRuleArray[n2];
                if ("target".equals(rule.getProtocol()) && ((query = rule.getContextQuery()) == null || query.length() <= 0 || query.equals("*")) && (targetPath = this.map(rule, hostPath)) != null) {
                    return targetPath;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String findHostPath(Object context, String targetPath) {
        IPathMap.PathMapRule[] rules;
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)targetPath);
        IPathMapService svc = (IPathMapService)ServiceManager.getInstance().getService(context, IPathMapService.class);
        if (svc != null && (rules = svc.getPathMap(context)) != null && rules.length > 0) {
            IPathMap.PathMapRule[] pathMapRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                String hostPath;
                String query;
                IPathMap.PathMapRule rule = pathMapRuleArray[n2];
                if (!"target".equals(rule.getProtocol()) && ((query = rule.getContextQuery()) == null || query.length() <= 0 || query.equals("*")) && (hostPath = this.map(rule, targetPath)) != null) {
                    File f;
                    if (hostPath.startsWith("/cygdrive/")) {
                        hostPath = String.valueOf(hostPath.substring(10, 11)) + ":" + hostPath.substring(11);
                    }
                    if ((f = new File(hostPath)).exists() && f.canRead()) {
                        return new Path(hostPath).toOSString();
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

