/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.hover;

import java.util.Map;
import org.eclipse.cdt.debug.ui.editors.AbstractDebugTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.cdt.ui.hover.ExpressionInformationControlCreator;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFDebugTextHover
extends AbstractDebugTextHover
implements ITextHoverExtension2 {
    public IInformationControlCreator getHoverControlCreator() {
        if (this.useExpressionExplorer()) {
            return this.createExpressionInformationControlCreator();
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    private IInformationControlCreator createExpressionInformationControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    protected boolean useExpressionExplorer() {
        return true;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (!this.useExpressionExplorer()) {
            return this.getHoverInfo(textViewer, hoverRegion);
        }
        final TCFNodeStackFrame activeFrame = this.getActiveFrame();
        if (activeFrame == null) {
            return null;
        }
        final String text = this.getExpressionText(textViewer, hoverRegion);
        if (text == null || text.length() == 0) {
            return null;
        }
        try {
            return new TCFTask<TCFNode>(activeFrame.getChannel()){

                public void run() {
                    Object evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                    TCFChildren cache = evalContext.getModel().getHoverExpressionCache((TCFNode)evalContext, text);
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    Map nodes = (Map)cache.getData();
                    if (nodes != null) {
                        for (TCFNode node : nodes.values()) {
                            TCFDataCache value = ((TCFNodeExpression)node).getValue();
                            if (!value.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (value.getData() == null) continue;
                            this.done(node.getParent());
                            return;
                        }
                    }
                    this.done(null);
                }
            }.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean canEvaluate() {
        return this.getActiveFrame() != null;
    }

    private TCFNodeStackFrame getActiveFrame() {
        IAdaptable context = this.getSelectionAdaptable();
        if (context instanceof TCFNodeStackFrame) {
            return (TCFNodeStackFrame)context;
        }
        if (context instanceof TCFNodeExecContext) {
            try {
                final TCFNodeExecContext exe = (TCFNodeExecContext)context;
                return (TCFNodeStackFrame)new TCFTask<TCFNodeStackFrame>(exe.getChannel()){

                    public void run() {
                        TCFChildrenStackTrace stack = exe.getStackTrace();
                        if (!stack.validate((Runnable)((Object)this))) {
                            return;
                        }
                        this.done(stack.getTopFrame());
                    }
                }.get();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected String evaluateExpression(final String expression) {
        final TCFNodeStackFrame activeFrame = this.getActiveFrame();
        if (activeFrame == null) {
            return null;
        }
        final IChannel channel = activeFrame.getChannel();
        return (String)new TCFTask<String>(channel){

            public void run() {
                final IExpressions exprSvc = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (exprSvc != null) {
                    TCFNodeStackFrame evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                    exprSvc.create(evalContext.getID(), null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                exprSvc.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        this.done(error == null && value != null ? TCFDebugTextHover.getValueText(value) : null);
                                        exprSvc.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.done(null);
                            }
                        }
                    });
                } else {
                    this.done(null);
                }
            }
        }.getE();
    }

    private static String getValueText(IExpressions.Value value) {
        byte[] data = value.getValue();
        if (data == null) {
            return "N/A";
        }
        switch (value.getTypeClass()) {
            case integer: {
                return TCFNumberFormat.toBigInteger((byte[])data, (boolean)value.isBigEndian(), (boolean)true).toString();
            }
            case real: {
                return TCFNumberFormat.toFPString((byte[])data, (boolean)value.isBigEndian());
            }
            case complex: {
                return TCFNumberFormat.toComplexFPString((byte[])data, (boolean)value.isBigEndian());
            }
        }
        return "0x" + TCFNumberFormat.toBigInteger((byte[])data, (boolean)value.isBigEndian(), (boolean)false).toString(16);
    }
}

