/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.local;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.internal.core.Token;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDiagnostics;

public class DiagnosticsService
implements IDiagnostics {
    private final IChannel channel;

    public DiagnosticsService(IChannel channel) {
        this.channel = channel;
        channel.addCommandServer(this, new CommandServer());
    }

    @Override
    public String getName() {
        return "Diagnostics";
    }

    @Override
    public IToken echo(final String s, final IDiagnostics.DoneEcho done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneEcho(token, null, s);
            }
        });
        return token;
    }

    @Override
    public IToken echoFP(final BigDecimal n, final IDiagnostics.DoneEchoFP done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneEchoFP(token, null, n);
            }
        });
        return token;
    }

    @Override
    public IToken echoERR(final Throwable err, final IDiagnostics.DoneEchoERR done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (err instanceof IErrorReport) {
                    done.doneEchoERR(token, null, err, Command.toErrorString(((IErrorReport)((Object)err)).getAttributes()));
                } else {
                    done.doneEchoERR(token, null, err, err.getMessage());
                }
            }
        });
        return token;
    }

    @Override
    public IToken getTestList(final IDiagnostics.DoneGetTestList done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneGetTestList(token, null, new String[0]);
            }
        });
        return token;
    }

    @Override
    public IToken runTest(final String s, final IDiagnostics.DoneRunTest done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneRunTest(token, new Exception("Test suite not found: " + s), null);
            }
        });
        return token;
    }

    @Override
    public IToken cancelTest(String context_id, final IDiagnostics.DoneCancelTest done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneCancelTest(token, null);
            }
        });
        return token;
    }

    @Override
    public IToken getSymbol(String context_id, String symbol_name, final IDiagnostics.DoneGetSymbol done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneGetSymbol(token, new Exception("Invalid context"), null);
            }
        });
        return token;
    }

    @Override
    public IToken createTestStreams(int inp_buf_size, int out_buf_size, final IDiagnostics.DoneCreateTestStreams done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneCreateTestStreams(token, new Exception("Not implemented"), null, null);
            }
        });
        return token;
    }

    @Override
    public IToken disposeTestStream(String id, final IDiagnostics.DoneDisposeTestStream done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneDisposeTestStream(token, new Exception("Invalid context"));
            }
        });
        return token;
    }

    @Override
    public IToken not_implemented_command(final IDiagnostics.DoneNotImplementedCommand done) {
        final Token token = new Token();
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                done.doneNotImplementedCommand(token, new Exception("Not implemented"));
            }
        });
        return token;
    }

    private class CommandServer
    implements IChannel.ICommandServer {
        private CommandServer() {
        }

        @Override
        public void command(IToken token, String name, byte[] data) {
            try {
                this.command(token, name, JSON.parseSequence(data));
            }
            catch (Throwable x) {
                DiagnosticsService.this.channel.terminate(x);
            }
        }

        private void command(IToken token, String name, Object[] args) throws Exception {
            if (name.equals("echo")) {
                if (args.length != 1) {
                    throw new Exception("Invalid number of arguments");
                }
                String s = (String)args[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(new Object[]{s}));
            } else if (name.equals("echoFP")) {
                if (args.length != 1) {
                    throw new Exception("Invalid number of arguments");
                }
                Number n = (Number)args[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(new Object[]{n}));
            } else if (name.equals("echoERR")) {
                if (args.length != 1) {
                    throw new Exception("Invalid number of arguments");
                }
                Map err = (Map)args[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(new Object[]{err, Command.toErrorString(err)}));
            } else if (name.equals("getTestList")) {
                if (args.length != 0) {
                    throw new Exception("Invalid number of arguments");
                }
                Object[] objectArray = new Object[2];
                objectArray[1] = new String[0];
                DiagnosticsService.this.channel.sendResult(token, JSON.toJSONSequence(objectArray));
            } else {
                DiagnosticsService.this.channel.rejectCommand(token);
            }
        }
    }
}

