/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.RuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpRestoreFavorites
extends AbstractOperation
implements IResultOperation<IFSTreeNode[]> {
    private RuntimeModel fRuntimeModel;
    private List<IFSTreeNode> fResult = new ArrayList<IFSTreeNode>();

    public OpRestoreFavorites(RuntimeModel runtimeModel) {
        this.fRuntimeModel = runtimeModel;
    }

    @Override
    public IFSTreeNode[] getResult() {
        return this.fResult.toArray(new IFSTreeNode[this.fResult.size()]);
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        Set<String> favorites = CorePlugin.getDefault().getRevealOnConnect();
        if (favorites.isEmpty()) {
            return Status.OK_STATUS;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)favorites.size());
        for (String fav : favorites) {
            if (this.openFavorite(fav, sm.newChild(1)).getSeverity() != 8) continue;
            monitor.done();
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private IStatus openFavorite(String fav, SubMonitor sm) {
        IResultOperation<IFSTreeNode> op = this.fRuntimeModel.operationRestoreFromPath(fav);
        IStatus s = op.run((IProgressMonitor)sm);
        IFSTreeNode node = op.getResult();
        if (node != null) {
            this.fResult.add(node);
        }
        return s;
    }

    @Override
    public String getName() {
        return Messages.OpRestoreFavorites_name;
    }
}

