/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelQueryService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.services.PeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.services.PeerModelQueryService;
import org.eclipse.tcf.te.tcf.locator.services.PeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.services.PeerModelUpdateService;

public class PeerModel
extends PlatformObject
implements IPeerModel {
    private final UUID uniqueId = UUID.randomUUID();
    private boolean disposed = false;
    final Map<String, IPeerNode> peerNodes = new HashMap<String, IPeerNode>();
    private final List<IPeerModelListener> modelListener = new ArrayList<IPeerModelListener>();
    private final IPeerModelRefreshService refreshService = new PeerModelRefreshService(this);
    private final IPeerModelLookupService lookupService = new PeerModelLookupService(this);
    private final IPeerModelUpdateService updateService = new PeerModelUpdateService(this);
    private final IPeerModelQueryService queryService = new PeerModelQueryService(this);

    @Override
    public void addListener(IPeerModelListener listener) {
        Assert.isNotNull((Object)listener);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/peerModel")) {
            CoreBundleActivator.getTraceHandler().trace("PeerModel.addListener( " + listener + " )", "trace/peerModel", (Object)this);
        }
        if (!this.modelListener.contains(listener)) {
            this.modelListener.add(listener);
        }
    }

    @Override
    public void removeListener(IPeerModelListener listener) {
        Assert.isNotNull((Object)listener);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/peerModel")) {
            CoreBundleActivator.getTraceHandler().trace("PeerModel.removeListener( " + listener + " )", "trace/peerModel", (Object)this);
        }
        this.modelListener.remove(listener);
    }

    @Override
    public IPeerModelListener[] getListener() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return this.modelListener.toArray(new IPeerModelListener[this.modelListener.size()]);
    }

    @Override
    public void dispose() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/peerModel")) {
            CoreBundleActivator.getTraceHandler().trace("PeerModel.dispose()", "trace/peerModel", (Object)this);
        }
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        final IPeerModelListener[] listeners = this.getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeerModelListener[] iPeerModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPeerModelListener listener = iPeerModelListenerArray[n2];
                        listener.modelDisposed(PeerModel.this);
                        ++n2;
                    }
                }
            });
        }
        this.modelListener.clear();
        this.peerNodes.clear();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public IPeerNode[] getPeerNodes() {
        ArrayList<IPeerNode> values = new ArrayList<IPeerNode>(this.peerNodes.values());
        return values.toArray(new IPeerNode[values.size()]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IPeerModelRefreshService.class)) {
            return this.refreshService;
        }
        if (adapter.isAssignableFrom(IPeerModelLookupService.class)) {
            return this.lookupService;
        }
        if (adapter.isAssignableFrom(IPeerModelUpdateService.class)) {
            return this.updateService;
        }
        if (adapter.isAssignableFrom(IPeerModelQueryService.class)) {
            return this.queryService;
        }
        if (adapter.isAssignableFrom(Map.class)) {
            return this.peerNodes;
        }
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    @Override
    public <V extends IPeerModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((IPeerModelService)this.getAdapter(serviceInterface));
    }
}

