/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.lm.delegates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.launch.core.lm.delegates.DefaultLaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.interfaces.IRemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.runtime.services.interfaces.delegates.ILabelProviderDelegate;

public class AttachLaunchManagerDelegate
extends DefaultLaunchManagerDelegate {
    private static final String[] MANDATORY_CONFIG_ATTRIBUTES = new String[]{"org.eclipse.tcf.te.launch.launch_contexts"};

    public void updateLaunchConfigAttributes(ILaunchConfigurationWorkingCopy wc, ILaunchSpecification launchSpec) {
        super.updateLaunchConfigAttributes(wc, launchSpec);
        DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)wc, (String)"org.eclipse.tcf.te.tcf.launch.attach_services", null);
        DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)wc, (String)"org.eclipse.tcf.debug.DisconnectOnCtxExit", (boolean)false);
        this.copySpecToConfig(launchSpec, wc);
        wc.rename(this.getDefaultLaunchName((ILaunchConfiguration)wc));
    }

    public void initLaunchConfigAttributes(ILaunchConfigurationWorkingCopy wc, ILaunchSpecification launchSpec) {
        super.initLaunchConfigAttributes(wc, launchSpec);
        DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)wc, (String)"org.eclipse.tcf.te.tcf.launch.attach_services", null);
        DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)wc, (String)"org.eclipse.tcf.debug.DisconnectOnCtxExit", (boolean)false);
        this.copySpecToConfig(launchSpec, wc);
        wc.rename(this.getDefaultLaunchName((ILaunchConfiguration)wc));
    }

    public void updateLaunchConfig(ILaunchConfigurationWorkingCopy wc, ISelectionContext selContext, boolean replace) {
        super.updateLaunchConfig(wc, selContext, replace);
        if (selContext instanceof IRemoteSelectionContext) {
            IRemoteSelectionContext remoteCtx = (IRemoteSelectionContext)selContext;
            LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)wc, (IModelNode[])new IModelNode[]{remoteCtx.getRemoteCtx()});
        }
    }

    protected ILaunchSpecification addLaunchSpecAttributes(ILaunchSpecification launchSpec, String launchConfigTypeId, ISelectionContext selectionContext) {
        launchSpec = super.addLaunchSpecAttributes(launchSpec, launchConfigTypeId, selectionContext);
        if (selectionContext instanceof IRemoteSelectionContext) {
            IModelNode remoteCtx;
            ArrayList<IModelNode> launchContexts = new ArrayList<IModelNode>(Arrays.asList(LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchSpecification)launchSpec)));
            if (!launchContexts.contains(remoteCtx = ((IRemoteSelectionContext)selectionContext).getRemoteCtx())) {
                launchContexts.add(remoteCtx);
                LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchSpecification)launchSpec, (IModelNode[])launchContexts.toArray(new IModelNode[launchContexts.size()]));
            }
            launchSpec.setLaunchConfigName(this.getDefaultLaunchName(launchSpec));
        }
        return launchSpec;
    }

    public String getDefaultLaunchName(ILaunchSpecification launchSpec) {
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchSpecification)launchSpec);
        String name = this.getDefaultLaunchName(contexts != null && contexts.length > 0 ? contexts[0] : null);
        return name.trim().length() > 0 ? name.trim() : super.getDefaultLaunchName(launchSpec);
    }

    public String getDefaultLaunchName(ILaunchConfiguration launchConfig) {
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)launchConfig);
        String name = this.getDefaultLaunchName(contexts != null && contexts.length > 0 ? contexts[0] : null);
        return name.trim().length() > 0 ? name.trim() : super.getDefaultLaunchName(launchConfig);
    }

    private String getDefaultLaunchName(IModelNode context) {
        if (context != null) {
            ILabelProviderDelegate delegate = (ILabelProviderDelegate)ServiceUtils.getUIServiceDelegate((Object)context, (Object)context, ILabelProviderDelegate.class);
            String name = delegate != null ? delegate.getText((Object)context) : null;
            return name != null ? name : context.getName();
        }
        return "";
    }

    protected List<String> getMandatoryAttributes() {
        return Arrays.asList(MANDATORY_CONFIG_ATTRIBUTES);
    }

    protected int getNumAttributes() {
        return 1;
    }

    protected int getAttributeRanking(String attributeKey) {
        if ("org.eclipse.tcf.te.launch.launch_contexts".equals(attributeKey)) {
            return this.getNumAttributes() * 2;
        }
        return 1;
    }
}

