/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;

public class ActionStepOut
extends TCFAction
implements IRunControl.RunControlListener {
    protected final TCFNodeExecContext node;
    private final IDebugCommandRequest monitor;
    private final Runnable done;
    private final boolean step_back;
    private final TCFNodeStackFrame drop_to_frame;
    private final IRunControl rc;
    private final IBreakpoints bps;
    private int step_cnt;
    private Map<String, Object> bp;
    protected boolean exited;

    public ActionStepOut(TCFNodeExecContext node, boolean step_back, TCFNodeStackFrame drop_to_frame, IDebugCommandRequest monitor, Runnable done) {
        super(node.getModel().getLaunch(), node.getID());
        this.node = node;
        this.step_back = step_back;
        this.drop_to_frame = drop_to_frame;
        this.monitor = monitor;
        this.done = done;
        this.rc = (IRunControl)this.launch.getService(IRunControl.class);
        this.bps = (IBreakpoints)this.launch.getService(IBreakpoints.class);
    }

    public void run() {
        if (this.exited) {
            return;
        }
        try {
            this.runAction();
        }
        catch (Throwable x) {
            this.exit(x);
        }
    }

    private void runAction() {
        int mode;
        TCFDataCache<IRunControl.RunControlContext> ctx_cache;
        if (this.aborted) {
            this.exit(null);
            return;
        }
        TCFDataCache<TCFContextState> state = this.node.getState();
        if (state == null) {
            this.exit(new Exception("Invalid context ID"));
            return;
        }
        if (!state.validate((Runnable)((Object)this))) {
            return;
        }
        if (state.getData() == null || !((TCFContextState)state.getData()).is_suspended) {
            Throwable error = state.getError();
            if (error == null) {
                error = new Exception("Context is not suspended");
            }
            this.exit(error);
            return;
        }
        if (this.step_cnt == 0) {
            this.rc.addListener((IRunControl.RunControlListener)this);
        }
        if (!(ctx_cache = this.node.getRunContext()).validate((Runnable)((Object)this))) {
            return;
        }
        IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
        if (ctx_data == null) {
            this.exit(ctx_cache.getError());
            return;
        }
        int n = mode = this.step_back ? 11 : 5;
        if (this.drop_to_frame == null && ctx_data.canResume(mode)) {
            if (this.step_cnt > 0) {
                this.exit(null);
                return;
            }
            ctx_data.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOut.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        TCFChildrenStackTrace stack_trace = this.node.getStackTrace();
        if (!stack_trace.validate((Runnable)((Object)this))) {
            return;
        }
        if (this.step_cnt > 0) {
            TCFContextState state_data = (TCFContextState)state.getData();
            if (this.isMyBreakpoint(state_data)) {
                this.exit(null);
                return;
            }
            this.exit(null, state_data.suspend_reason);
            return;
        }
        if (this.bps != null && ctx_data.canResume(this.step_back ? 6 : 0)) {
            if (this.bp == null) {
                TCFDataCache<IStackTrace.StackTraceContext> frame_cache = (this.drop_to_frame != null ? this.drop_to_frame : stack_trace.getTopFrame()).getStackTraceContext();
                if (!frame_cache.validate((Runnable)((Object)this))) {
                    return;
                }
                IStackTrace.StackTraceContext frame_data = (IStackTrace.StackTraceContext)frame_cache.getData();
                if (frame_data == null) {
                    this.exit(frame_cache.getError());
                    return;
                }
                Number addr = frame_data.getReturnAddress();
                if (addr == null) {
                    this.exit(new Exception("Unknown stack frame return address"));
                    return;
                }
                if (this.step_back) {
                    BigInteger n2 = JSON.toBigInteger((Number)addr);
                    addr = n2.subtract(BigInteger.valueOf(1L));
                }
                String id = "Step." + ctx_data.getID();
                this.bp = new HashMap<String, Object>();
                this.bp.put("ID", id);
                this.bp.put("Location", addr.toString());
                this.bp.put("Condition", "$thread==\"" + ctx_data.getID() + "\"");
                this.bp.put("Enabled", Boolean.TRUE);
                this.bps.add(this.bp, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            ActionStepOut.this.exit(error);
                        }
                    }
                });
            }
            ctx_data.resume(this.step_back ? 6 : 0, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOut.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        this.exit(new Exception("Step out is not supported"));
    }

    protected void exit(Throwable error) {
        if (this.exited) {
            return;
        }
        this.exit(error, "Step Out");
        if (error != null && this.node.getChannel().getState() == 1) {
            this.monitor.setStatus((IStatus)new Status(4, "org.eclipse.tcf.debug.ui", 0, "Cannot step: " + error.getLocalizedMessage(), error));
        }
        this.done.run();
    }

    protected void exit(Throwable error, String reason) {
        if (this.exited) {
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.exited = true;
        if (error == null) {
            this.setActionResult(this.getContextID(), reason);
        } else {
            this.launch.removeContextActions(this.getContextID());
        }
        this.done();
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
    }

    public void contextException(String context, String msg) {
        if (context.equals(this.node.getID())) {
            this.exit(new Exception(msg));
        }
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            if (context.equals(this.node.getID())) {
                this.exit(null);
            }
            ++n2;
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        if (!context.equals(this.node.getID())) {
            return;
        }
        Protocol.invokeLater((Runnable)((Object)this));
    }

    private boolean isMyBreakpoint(TCFContextState state_data) {
        Collection c;
        Object ids;
        if (this.bp == null) {
            return false;
        }
        if (!"Breakpoint".equals(state_data.suspend_reason)) {
            return false;
        }
        if (state_data.suspend_params != null && (ids = state_data.suspend_params.get("BPs")) != null && (c = (Collection)ids).contains(this.bp.get("ID"))) {
            return true;
        }
        if (state_data.suspend_pc == null) {
            return false;
        }
        BigInteger x = new BigInteger(state_data.suspend_pc);
        BigInteger y = new BigInteger((String)this.bp.get("Location"));
        return x.equals(y);
    }
}

