/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;

public class ActionStepOver
extends TCFAction
implements IRunControl.RunControlListener {
    protected final TCFNodeExecContext node;
    private final IDebugCommandRequest monitor;
    private final Runnable done;
    private boolean step_line;
    private boolean step_back;
    private final IRunControl rc;
    private final IBreakpoints bps;
    private TCFSourceRef source_ref;
    private BigInteger pc0;
    private BigInteger pc1;
    private BigInteger fp;
    private int step_cnt;
    private Map<String, Object> bp;
    private boolean second_step_back;
    private boolean final_step;
    protected boolean exited;

    public ActionStepOver(TCFNodeExecContext node, boolean step_line, boolean step_back, IDebugCommandRequest monitor, Runnable done) {
        super(node.getModel().getLaunch(), node.getID());
        this.node = node;
        this.step_line = step_line;
        this.step_back = step_back;
        this.monitor = monitor;
        this.done = done;
        this.rc = (IRunControl)this.launch.getService(IRunControl.class);
        this.bps = (IBreakpoints)this.launch.getService(IBreakpoints.class);
    }

    public void run() {
        if (this.exited) {
            return;
        }
        try {
            this.runAction();
        }
        catch (Throwable x) {
            this.exit(x);
        }
    }

    private void setSourceRef(TCFSourceRef ref) {
        ILineNumbers.CodeArea area = ref.area;
        if (area != null) {
            this.pc0 = JSON.toBigInteger((Number)area.start_address);
            this.pc1 = JSON.toBigInteger((Number)area.end_address);
        } else {
            this.pc0 = null;
            this.pc1 = null;
        }
        this.source_ref = ref;
    }

    private void runAction() {
        TCFDataCache<IStackTrace.StackTraceContext> frame_cache;
        if (this.aborted) {
            this.exit(null);
            return;
        }
        TCFDataCache<TCFContextState> state_cache = this.node.getState();
        if (state_cache == null) {
            this.exit(new Exception("Invalid context ID"));
            return;
        }
        if (!state_cache.validate((Runnable)((Object)this))) {
            return;
        }
        if (state_cache.getData() == null || !((TCFContextState)state_cache.getData()).is_suspended) {
            Throwable error = state_cache.getError();
            if (error == null) {
                error = new Exception("Context is not suspended");
            }
            this.exit(error);
            return;
        }
        if (this.step_cnt == 0) {
            this.rc.addListener((IRunControl.RunControlListener)this);
        } else {
            TCFContextState state_data = (TCFContextState)state_cache.getData();
            if (!"Step".equals(state_data.suspend_reason) && !this.isMyBreakpoint(state_data)) {
                this.exit(null, state_data.suspend_reason);
                return;
            }
        }
        TCFDataCache<IRunControl.RunControlContext> ctx_cache = this.node.getRunContext();
        if (!ctx_cache.validate((Runnable)((Object)this))) {
            return;
        }
        IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
        if (ctx_data == null) {
            this.exit(ctx_cache.getError());
            return;
        }
        int mode = 0;
        if (!this.step_line) {
            mode = this.step_back ? 7 : 1;
        } else {
            int n = mode = this.step_back ? 9 : 3;
        }
        if (ctx_data.canResume(mode)) {
            if (this.step_cnt > 0) {
                this.exit(null);
                return;
            }
            ctx_data.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOver.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        TCFChildrenStackTrace stack_trace = this.node.getStackTrace();
        if (!stack_trace.validate((Runnable)((Object)this))) {
            return;
        }
        TCFNodeStackFrame frame_node = stack_trace.getTopFrame();
        if (this.step_line && this.source_ref == null) {
            TCFDataCache<TCFSourceRef> line_info = frame_node.getLineInfo();
            if (!line_info.validate((Runnable)((Object)this))) {
                return;
            }
            TCFSourceRef ref = (TCFSourceRef)line_info.getData();
            if (ref == null) {
                this.step_line = false;
                Protocol.invokeLater((Runnable)((Object)this));
                return;
            }
            if (ref.error != null) {
                this.exit(ref.error);
                return;
            }
            this.setSourceRef(ref);
        }
        if (!(frame_cache = frame_node.getStackTraceContext()).validate((Runnable)((Object)this))) {
            return;
        }
        IStackTrace.StackTraceContext frame_data = (IStackTrace.StackTraceContext)frame_cache.getData();
        int frame_pos = 0;
        if (this.step_cnt == 0) {
            if (frame_data != null) {
                this.fp = JSON.toBigInteger((Number)frame_data.getFrameAddress());
            }
            if (this.fp == null) {
                this.exit(new Exception("Unknown frame address"));
                return;
            }
        } else if (frame_data != null && this.fp.equals(JSON.toBigInteger((Number)frame_data.getFrameAddress()))) {
            frame_pos = 0;
        } else {
            frame_pos = -1;
            for (TCFNode n : ((Map)stack_trace.getData()).values()) {
                TCFDataCache<IStackTrace.StackTraceContext> cache = ((TCFNodeStackFrame)n).getStackTraceContext();
                if (!cache.validate((Runnable)((Object)this))) {
                    return;
                }
                IStackTrace.StackTraceContext data = (IStackTrace.StackTraceContext)cache.getData();
                if (data == null || !this.fp.equals(JSON.toBigInteger((Number)data.getFrameAddress()))) continue;
                frame_pos = 1;
                break;
            }
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOver.this.exit(error);
                    }
                }
            });
            this.bp = null;
        }
        if (frame_pos > 0) {
            int n = mode = this.step_back ? 11 : 5;
            if (ctx_data.canResume(mode)) {
                ctx_data.resume(mode, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            ActionStepOver.this.exit(error);
                        }
                    }
                });
                return;
            }
            int n2 = mode = this.step_back ? 6 : 0;
            if (this.bps != null && ctx_data.canResume(mode)) {
                Number addr = null;
                if (frame_data != null) {
                    addr = frame_data.getReturnAddress();
                }
                if (addr == null) {
                    this.exit(new Exception("Unknown return address"));
                    return;
                }
                if (this.step_back) {
                    BigInteger n3 = JSON.toBigInteger((Number)addr);
                    addr = n3.subtract(BigInteger.valueOf(1L));
                }
                String id = "Step." + ctx_data.getID();
                this.bp = new HashMap<String, Object>();
                this.bp.put("ID", id);
                this.bp.put("Location", addr.toString());
                this.bp.put("Condition", "$thread==\"" + ctx_data.getID() + "\"");
                this.bp.put("Enabled", Boolean.TRUE);
                this.bps.add(this.bp, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            ActionStepOver.this.exit(error);
                        }
                    }
                });
                ctx_data.resume(mode, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            ActionStepOver.this.exit(error);
                        }
                    }
                });
                ++this.step_cnt;
                return;
            }
            this.exit(new Exception("Step over is not supported"));
            return;
        }
        BigInteger pc = new BigInteger(((TCFContextState)state_cache.getData()).suspend_pc);
        if (this.step_cnt > 0) {
            if (pc == null || this.pc0 == null || this.pc1 == null) {
                this.exit(null);
                return;
            }
            assert (this.step_line);
            if (pc.compareTo(this.pc0) < 0 || pc.compareTo(this.pc1) >= 0) {
                TCFDataCache<TCFSourceRef> line_info = frame_node.getLineInfo();
                if (!line_info.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFSourceRef ref = (TCFSourceRef)line_info.getData();
                if (ref == null || ref.area == null) {
                    if (frame_pos < 0 && (stack_trace.getError() == null || this.step_cnt >= 10)) {
                        this.exit(stack_trace.getError());
                        return;
                    }
                } else if (this.isSameLine(this.source_ref.area, ref.area)) {
                    this.setSourceRef(ref);
                } else if (this.step_back && !this.second_step_back) {
                    this.second_step_back = true;
                    this.setSourceRef(ref);
                } else if (this.step_back && !this.final_step) {
                    this.final_step = true;
                    this.step_back = false;
                    this.setSourceRef(ref);
                } else {
                    this.exit(null);
                    return;
                }
            }
        }
        ++this.step_cnt;
        int n = mode = this.step_back ? 7 : 1;
        if (ctx_data.canResume(mode)) {
            ctx_data.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOver.this.exit(error);
                    }
                }
            });
            return;
        }
        int n4 = mode = this.step_back ? 15 : 13;
        if (ctx_data.canResume(mode) && pc != null && this.pc0 != null && this.pc1 != null && pc.compareTo(this.pc0) >= 0 && pc.compareTo(this.pc1) < 0) {
            HashMap<String, BigInteger> args = new HashMap<String, BigInteger>();
            args.put("RangeStart", this.pc0);
            args.put("RangeEnd", this.pc1);
            ctx_data.resume(mode, 1, args, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOver.this.exit(error);
                    }
                }
            });
            return;
        }
        int n5 = mode = this.step_back ? 8 : 2;
        if (ctx_data.canResume(mode)) {
            ctx_data.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        ActionStepOver.this.exit(error);
                    }
                }
            });
            return;
        }
        this.exit(new Exception("Step over is not supported"));
    }

    protected void exit(Throwable error) {
        if (this.exited) {
            return;
        }
        this.exit(error, "Step Over");
        if (error != null && this.node.getChannel().getState() == 1) {
            this.monitor.setStatus((IStatus)new Status(4, "org.eclipse.tcf.debug.ui", 0, "Cannot step: " + error.getLocalizedMessage(), error));
        }
        this.done.run();
    }

    protected void exit(Throwable error, String reason) {
        if (this.exited) {
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.exited = true;
        if (error == null) {
            this.setActionResult(this.getContextID(), reason);
        } else {
            this.launch.removeContextActions(this.getContextID());
        }
        this.done();
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
    }

    public void contextException(String context, String msg) {
        if (context.equals(this.node.getID())) {
            this.exit(new Exception(msg));
        }
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            if (context.equals(this.node.getID())) {
                this.exit(null);
            }
            ++n2;
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        if (!context.equals(this.node.getID())) {
            return;
        }
        Protocol.invokeLater((Runnable)((Object)this));
    }

    private boolean isSameLine(ILineNumbers.CodeArea x, ILineNumbers.CodeArea y) {
        if (x == null || y == null) {
            return false;
        }
        if (x.start_line != y.start_line) {
            return false;
        }
        if (!(x.directory == y.directory || x.directory != null && x.directory.equals(y.directory))) {
            return false;
        }
        return x.file == y.file || x.file != null && x.file.equals(y.file);
    }

    private boolean isMyBreakpoint(TCFContextState state_data) {
        Collection c;
        Object ids;
        if (this.bp == null) {
            return false;
        }
        if (!"Breakpoint".equals(state_data.suspend_reason)) {
            return false;
        }
        if (state_data.suspend_params != null && (ids = state_data.suspend_params.get("BPs")) != null && (c = (Collection)ids).contains(this.bp.get("ID"))) {
            return true;
        }
        if (state_data.suspend_pc == null) {
            return false;
        }
        BigInteger x = new BigInteger(state_data.suspend_pc);
        BigInteger y = new BigInteger((String)this.bp.get("Location"));
        return x.equals(y);
    }
}

