/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.statushandler;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.runtime.statushandler.internal.StatusHandlerBinding;
import org.eclipse.tcf.te.runtime.statushandler.internal.StatusHandlerBindingExtensionPointManager;

public final class StatusHandlerManager
extends AbstractExtensionPointManager<IStatusHandler> {
    StatusHandlerManager() {
    }

    public static StatusHandlerManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.runtime.statushandler.handlers";
    }

    protected String getConfigurationElementName() {
        return "handler";
    }

    public IStatusHandler[] getHandlers(boolean unique) {
        ArrayList<IStatusHandler> contributions = new ArrayList<IStatusHandler>();
        Collection statusHandlers = this.getExtensions().values();
        for (ExecutableExtensionProxy statusHandler : statusHandlers) {
            IStatusHandler instance;
            IStatusHandler iStatusHandler = instance = unique ? (IStatusHandler)statusHandler.newInstance() : (IStatusHandler)statusHandler.getInstance();
            if (instance == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new IStatusHandler[contributions.size()]);
    }

    public IStatusHandler getHandler(String id, boolean unique) {
        IStatusHandler contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = unique ? (IStatusHandler)proxy.newInstance() : (IStatusHandler)proxy.getInstance();
        }
        return contribution;
    }

    public IStatusHandler[] getHandler(Object context) {
        StatusHandlerBinding[] bindings;
        Assert.isNotNull((Object)context);
        ArrayList<IStatusHandler> handlers = new ArrayList<IStatusHandler>();
        StatusHandlerBinding[] statusHandlerBindingArray = bindings = StatusHandlerBindingExtensionPointManager.getInstance().getApplicableBindings(context);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            StatusHandlerBinding binding = statusHandlerBindingArray[n2];
            IStatusHandler handler = this.getHandler(binding.getHandlerId(), false);
            if (handler != null && !handlers.contains(handler)) {
                handlers.add(handler);
            }
            ++n2;
        }
        if (handlers.isEmpty()) {
            IStatusHandler handler = this.getHandler("org.eclipse.tcf.te.statushandler.default", false);
            Assert.isNotNull((Object)handler);
            handlers.add(handler);
        }
        return handlers.toArray(new IStatusHandler[handlers.size()]);
    }

    private static class LazyInstance {
        public static StatusHandlerManager instance = new StatusHandlerManager();

        private LazyInstance() {
        }
    }
}

