/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.beans.PropertyChangeEvent;
import java.io.File;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;

public class FileState {
    private byte[] base_digest = null;
    private byte[] target_digest = null;
    private byte[] cache_digest = null;
    private long cache_mtime;
    private long target_mtime;
    transient boolean cache_digest_running = false;
    transient boolean target_digest_running = false;
    private transient FSTreeNode node;

    public FileState(FSTreeNode node) {
        this.node = node;
    }

    public FileState(long mtime, long target_mtime, byte[] cache_digest, byte[] target_digest, byte[] base_digest) {
        this.cache_mtime = mtime;
        this.target_mtime = target_mtime;
        this.cache_digest = cache_digest;
        this.target_digest = target_digest;
        this.base_digest = base_digest;
    }

    void setNode(FSTreeNode node) {
        this.node = node;
    }

    public byte[] getTargetDigest() {
        return this.target_digest;
    }

    public byte[] getBaseDigest() {
        return this.base_digest;
    }

    public long getCacheMTime() {
        return this.cache_mtime;
    }

    public long getTargetMTime() {
        return this.target_mtime;
    }

    public byte[] getCacheDigest() {
        return this.cache_digest;
    }

    public synchronized CacheState getCacheState() {
        File file = CacheManager.getCacheFile(this.node);
        if (!file.exists()) {
            return CacheState.consistent;
        }
        if (this.cache_digest == null || this.target_digest == null) {
            return CacheState.consistent;
        }
        if (this.isUnchanged(this.target_digest, this.cache_digest)) {
            this.base_digest = this.target_digest;
            return CacheState.consistent;
        }
        if (this.isUnchanged(this.base_digest, this.cache_digest)) {
            return CacheState.outdated;
        }
        if (this.isUnchanged(this.target_digest, this.base_digest)) {
            return CacheState.modified;
        }
        return CacheState.conflict;
    }

    public void updateTargetDigest(byte[] target_digest, long mtime) {
        this.target_digest = target_digest;
        this.target_mtime = mtime;
        PropertyChangeEvent event = new PropertyChangeEvent(this, "target_digest", null, target_digest);
        this.node.getRuntimeModel().firePropertyChanged(event);
    }

    private boolean isUnchanged(byte[] digest1, byte[] digest2) {
        if (digest1 != null && digest2 != null && digest1.length == digest2.length) {
            int i = 0;
            while (i < digest1.length) {
                if (digest1[i] != digest2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void updateCacheDigest(byte[] cache_digest, long mtime) {
        byte[] old_digest = cache_digest;
        this.cache_digest = cache_digest;
        this.cache_mtime = mtime;
        PropertyChangeEvent event = new PropertyChangeEvent(this.node, "cache_digest", old_digest, cache_digest);
        this.node.getRuntimeModel().firePropertyChanged(event);
    }

    public void reset(byte[] digest, long cache_mtime, long target_mtime) {
        this.cache_digest = digest;
        this.target_digest = digest;
        this.base_digest = digest;
        this.cache_mtime = cache_mtime;
        this.target_mtime = target_mtime;
        PropertyChangeEvent event = new PropertyChangeEvent(this.node, "reset_digest", null, digest);
        this.node.getRuntimeModel().firePropertyChanged(event);
    }
}

