/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.services;

import java.io.IOException;
import java.util.Map;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;

public interface IFileSystem
extends IService {
    public static final String NAME = "FileSystem";
    public static final int TCF_O_READ = 1;
    public static final int TCF_O_WRITE = 2;
    public static final int TCF_O_APPEND = 4;
    public static final int TCF_O_CREAT = 8;
    public static final int TCF_O_TRUNC = 16;
    public static final int TCF_O_EXCL = 32;
    public static final int ATTR_SIZE = 1;
    public static final int ATTR_UIDGID = 2;
    public static final int ATTR_PERMISSIONS = 4;
    public static final int ATTR_ACMODTIME = 8;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int STATUS_EOF = 65537;
    public static final int STATUS_NO_SUCH_FILE = 65538;
    public static final int STATUS_PERMISSION_DENIED = 65539;

    public IToken open(String var1, int var2, FileAttrs var3, DoneOpen var4);

    public IToken close(IFileHandle var1, DoneClose var2);

    public IToken read(IFileHandle var1, long var2, int var4, DoneRead var5);

    public IToken write(IFileHandle var1, long var2, byte[] var4, int var5, int var6, DoneWrite var7);

    public IToken stat(String var1, DoneStat var2);

    public IToken lstat(String var1, DoneStat var2);

    public IToken fstat(IFileHandle var1, DoneStat var2);

    public IToken setstat(String var1, FileAttrs var2, DoneSetStat var3);

    public IToken fsetstat(IFileHandle var1, FileAttrs var2, DoneSetStat var3);

    public IToken opendir(String var1, DoneOpen var2);

    public IToken readdir(IFileHandle var1, DoneReadDir var2);

    public IToken mkdir(String var1, FileAttrs var2, DoneMkDir var3);

    public IToken rmdir(String var1, DoneRemove var2);

    public IToken roots(DoneRoots var1);

    public IToken remove(String var1, DoneRemove var2);

    public IToken realpath(String var1, DoneRealPath var2);

    public IToken rename(String var1, String var2, DoneRename var3);

    public IToken readlink(String var1, DoneReadLink var2);

    public IToken symlink(String var1, String var2, DoneSymLink var3);

    public IToken copy(String var1, String var2, boolean var3, boolean var4, DoneCopy var5);

    public IToken user(DoneUser var1);

    public static final class DirEntry {
        public final String filename;
        public final String longname;
        public final FileAttrs attrs;

        public DirEntry(String filename, String longname, FileAttrs attrs) {
            this.filename = filename;
            this.longname = longname;
            this.attrs = attrs;
        }
    }

    public static interface DoneClose {
        public void doneClose(IToken var1, FileSystemException var2);
    }

    public static interface DoneCopy {
        public void doneCopy(IToken var1, FileSystemException var2);
    }

    public static interface DoneMkDir {
        public void doneMkDir(IToken var1, FileSystemException var2);
    }

    public static interface DoneOpen {
        public void doneOpen(IToken var1, FileSystemException var2, IFileHandle var3);
    }

    public static interface DoneRead {
        public void doneRead(IToken var1, FileSystemException var2, byte[] var3, boolean var4);
    }

    public static interface DoneReadDir {
        public void doneReadDir(IToken var1, FileSystemException var2, DirEntry[] var3, boolean var4);
    }

    public static interface DoneReadLink {
        public void doneReadLink(IToken var1, FileSystemException var2, String var3);
    }

    public static interface DoneRealPath {
        public void doneRealPath(IToken var1, FileSystemException var2, String var3);
    }

    public static interface DoneRemove {
        public void doneRemove(IToken var1, FileSystemException var2);
    }

    public static interface DoneRename {
        public void doneRename(IToken var1, FileSystemException var2);
    }

    public static interface DoneRoots {
        public void doneRoots(IToken var1, FileSystemException var2, DirEntry[] var3);
    }

    public static interface DoneSetStat {
        public void doneSetStat(IToken var1, FileSystemException var2);
    }

    public static interface DoneStat {
        public void doneStat(IToken var1, FileSystemException var2, FileAttrs var3);
    }

    public static interface DoneSymLink {
        public void doneSymLink(IToken var1, FileSystemException var2);
    }

    public static interface DoneUser {
        public void doneUser(IToken var1, FileSystemException var2, int var3, int var4, int var5, int var6, String var7);
    }

    public static interface DoneWrite {
        public void doneWrite(IToken var1, FileSystemException var2);
    }

    public static final class FileAttrs {
        public final int flags;
        public final long size;
        public final int uid;
        public final int gid;
        public final int permissions;
        public final long atime;
        public final long mtime;
        public final Map<String, Object> attributes;

        public FileAttrs(int flags, long size, int uid, int gid, int permissions, long atime, long mtime, Map<String, Object> attributes) {
            this.flags = flags;
            this.size = size;
            this.uid = uid;
            this.gid = gid;
            this.permissions = permissions;
            this.atime = atime;
            this.mtime = mtime;
            this.attributes = attributes;
        }

        public boolean isFile() {
            if ((this.flags & 4) == 0) {
                return false;
            }
            return (this.permissions & 0xF000) == 32768;
        }

        public boolean isDirectory() {
            if ((this.flags & 4) == 0) {
                return false;
            }
            return (this.permissions & 0xF000) == 16384;
        }
    }

    public static abstract class FileSystemException
    extends IOException {
        protected FileSystemException(String message) {
            super(message);
        }

        protected FileSystemException(Exception x) {
            super(x.getMessage());
            this.initCause(x);
        }

        public abstract int getStatus();
    }

    public static interface IFileHandle {
        public IFileSystem getService();
    }
}

