/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.local;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.internal.core.ChannelLoop;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;

class ChannelProxy {
    private final AbstractChannel ch_x;
    private final AbstractChannel ch_y;
    private boolean closed_x;
    private boolean closed_y;
    private final Map<IToken, IToken> tokens_x = new HashMap<IToken, IToken>();
    private final Map<IToken, IToken> tokens_y = new HashMap<IToken, IToken>();
    private final AbstractChannel.Proxy proxy_x = new AbstractChannel.Proxy(){

        @Override
        public void onChannelClosed(Throwable error) {
            ChannelProxy.this.closed_x = true;
            if (ChannelProxy.this.closed_y) {
                return;
            }
            if (error == null) {
                ChannelProxy.this.ch_y.close();
            } else {
                ChannelProxy.this.ch_y.terminate(error);
            }
        }

        @Override
        public void onCommand(IToken token, String service, String name, byte[] data) {
            if (ChannelProxy.this.closed_y) {
                return;
            }
            if (!$assertionsDisabled && ChannelProxy.this.ch_y.getState() != 1) {
                throw new AssertionError();
            }
            IService s = ChannelProxy.this.ch_y.getRemoteService(service);
            if (s == null) {
                ChannelProxy.this.ch_x.terminate(new IOException("Invalid service name"));
            } else {
                ChannelProxy.this.tokens_x.put(ChannelProxy.this.ch_y.sendCommand(s, name, data, ChannelProxy.this.cmd_listener_x), token);
            }
        }

        @Override
        public void onEvent(String service, String name, byte[] data) {
            IService s = ChannelProxy.this.ch_x.getRemoteService(service);
            if (s == null) {
                ChannelProxy.this.ch_x.terminate(new IOException("Invalid service name"));
            } else if (!ChannelProxy.this.closed_y) {
                ChannelProxy.this.ch_y.sendEvent(s, name, data);
            }
        }
    };
    private final AbstractChannel.Proxy proxy_y = new AbstractChannel.Proxy(){

        @Override
        public void onChannelClosed(Throwable error) {
            ChannelProxy.this.closed_y = true;
            if (ChannelProxy.this.closed_x) {
                return;
            }
            if (error == null) {
                ChannelProxy.this.ch_x.close();
            } else {
                ChannelProxy.this.ch_x.terminate(error);
            }
        }

        @Override
        public void onCommand(IToken token, String service, String name, byte[] data) {
            if (ChannelProxy.this.closed_x) {
                return;
            }
            if (!$assertionsDisabled && ChannelProxy.this.ch_x.getState() != 1) {
                throw new AssertionError();
            }
            IService s = ChannelProxy.this.ch_x.getRemoteService(service);
            if (s == null) {
                ChannelProxy.this.ch_y.terminate(new IOException("Invalid service name"));
            } else {
                ChannelProxy.this.tokens_y.put(ChannelProxy.this.ch_x.sendCommand(s, name, data, ChannelProxy.this.cmd_listener_y), token);
            }
        }

        @Override
        public void onEvent(String service, String name, byte[] data) {
            IService s = ChannelProxy.this.ch_y.getRemoteService(service);
            if (s == null) {
                ChannelProxy.this.ch_y.terminate(new IOException("Invalid service name"));
            } else if (!ChannelProxy.this.closed_x) {
                ChannelProxy.this.ch_x.sendEvent(s, name, data);
            }
        }
    };
    private final IChannel.ICommandListener cmd_listener_x = new IChannel.ICommandListener(){

        @Override
        public void progress(IToken token, byte[] data) {
            ChannelProxy.this.ch_x.sendProgress((IToken)ChannelProxy.this.tokens_x.get(token), data);
        }

        @Override
        public void result(IToken token, byte[] data) {
            ChannelProxy.this.ch_x.sendResult((IToken)ChannelProxy.this.tokens_x.remove(token), data);
        }

        @Override
        public void terminated(IToken token, Exception error) {
            ChannelProxy.this.ch_x.rejectCommand((IToken)ChannelProxy.this.tokens_x.remove(token));
        }
    };
    private final IChannel.ICommandListener cmd_listener_y = new IChannel.ICommandListener(){

        @Override
        public void progress(IToken token, byte[] data) {
            ChannelProxy.this.ch_y.sendProgress((IToken)ChannelProxy.this.tokens_y.get(token), data);
        }

        @Override
        public void result(IToken token, byte[] data) {
            ChannelProxy.this.ch_y.sendResult((IToken)ChannelProxy.this.tokens_y.remove(token), data);
        }

        @Override
        public void terminated(IToken token, Exception error) {
            ChannelProxy.this.ch_y.rejectCommand((IToken)ChannelProxy.this.tokens_y.remove(token));
        }
    };

    ChannelProxy(IChannel x, IChannel y) {
        assert (!(x instanceof ChannelLoop));
        assert (!(y instanceof ChannelLoop));
        this.ch_x = (AbstractChannel)x;
        this.ch_y = (AbstractChannel)y;
        assert (this.ch_x.getState() == 1);
        assert (this.ch_y.getState() == 0);
        try {
            this.ch_y.setProxy(this.proxy_y, this.ch_x.getRemoteServices());
            this.ch_y.addChannelListener(new IChannel.IChannelListener(){

                @Override
                public void congestionLevel(int level) {
                }

                @Override
                public void onChannelClosed(Throwable error) {
                    ChannelProxy.this.ch_y.removeChannelListener(this);
                    if (error == null) {
                        error = new Exception("Channel closed");
                    }
                    ChannelProxy.this.ch_x.terminate(error);
                }

                @Override
                public void onChannelOpened() {
                    ChannelProxy.this.ch_y.removeChannelListener(this);
                    try {
                        ChannelProxy.this.ch_x.setProxy(ChannelProxy.this.proxy_x, ChannelProxy.this.ch_y.getRemoteServices());
                    }
                    catch (IOException e) {
                        ChannelProxy.this.ch_x.terminate(e);
                        ChannelProxy.this.ch_y.terminate(e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.ch_x.terminate(e);
            this.ch_y.terminate(e);
        }
    }
}

