/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.internal.core.RemotePath;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnectionManager;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationChildStores;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationDelete;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationFetchInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationMkDir;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationOpenInputStream;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationOpenOutputStream;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationPutInfo;

public final class TCFFileStore
extends FileStore {
    public static final String SCHEME = "tcf";
    public static final String NOSLASH_MARKER = "/./";
    private final TCFConnection fConnection;
    private final String fPath;
    private IFileSystem.FileAttrs fAttributes;
    private TCFFileStore fParent;
    private boolean fArtificialRoot;

    public static String addNoSlashMarker(String path) {
        if (path.length() > 0 && path.charAt(0) != '/') {
            return NOSLASH_MARKER + path;
        }
        return path;
    }

    public static String stripNoSlashMarker(String path) {
        if (path.startsWith(NOSLASH_MARKER)) {
            return path.substring(NOSLASH_MARKER.length());
        }
        return path;
    }

    public static URI toURI(TCFConnection connection, String path) {
        try {
            return new URI(SCHEME, connection.getName(), TCFFileStore.addNoSlashMarker(path), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String toPath(URI uri) {
        return TCFFileStore.stripNoSlashMarker(uri.getPath());
    }

    public static TCFConnection toConnection(URI uri) {
        IRemoteServicesManager rsm = CoreBundleActivator.getService(IRemoteServicesManager.class);
        if (rsm == null) {
            return null;
        }
        IRemoteConnectionType ct = rsm.getConnectionType(uri);
        if (ct == null) {
            return null;
        }
        String peerName = uri.getAuthority();
        if (peerName == null) {
            return null;
        }
        return TCFConnectionManager.INSTANCE.mapConnection(ct.getConnection(peerName));
    }

    public static IFileStore getInstance(URI uri) {
        TCFConnection connection = TCFFileStore.toConnection(uri);
        String path = TCFFileStore.toPath(uri);
        if (connection != null) {
            return new TCFFileStore(connection, path, null);
        }
        return EFS.getNullFileSystem().getStore((IPath)RemotePath.forPosix((String)path));
    }

    TCFFileStore(TCFConnection connection, String path, TCFFileStore parent) {
        this.fPath = path;
        this.fConnection = connection;
        this.fParent = parent;
    }

    public URI toURI() {
        return TCFFileStore.toURI(this.fConnection, this.fPath);
    }

    public TCFConnection getConnection() {
        return this.fConnection;
    }

    public String getPath() {
        return this.fPath;
    }

    public void setAttributes(IFileSystem.FileAttrs attrs) {
        this.fAttributes = attrs;
    }

    public IFileSystem.FileAttrs getAttributes() {
        return this.fAttributes;
    }

    public IFileStore getChild(String name) {
        if (name.length() > 1 && name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String path = this.fArtificialRoot ? name : (this.fPath.endsWith("/") ? String.valueOf(this.fPath) + name : String.valueOf(this.fPath) + "/" + name);
        return new TCFFileStore(this.fConnection, path, this);
    }

    public String getName() {
        String path = this.getPath();
        if (this.fParent == null || this.fParent.fArtificialRoot) {
            return path;
        }
        int idx = path.lastIndexOf(47, path.length() - 2);
        if (idx > 0) {
            return path.substring(idx + 1);
        }
        return path;
    }

    public IFileStore getParent() {
        if (this.fParent != null) {
            return this.fParent;
        }
        int idx = this.fPath.lastIndexOf(47);
        if (idx < 1) {
            return null;
        }
        this.fParent = new TCFFileStore(this.fConnection, this.fPath.substring(0, idx - 1), null);
        return this.fParent;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return (IFileInfo)new TCFOperationFetchInfo(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return new FileInfo(this.getName());
        }
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return (IFileStore[])new TCFOperationChildStores(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return new IFileStore[0];
        }
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] children = this.childStores(options, monitor);
        String[] result = new String[children.length];
        int i = 0;
        IFileStore[] iFileStoreArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore s = iFileStoreArray[n2];
            result[i++] = s.getName();
            ++n2;
        }
        return result;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            new TCFOperationDelete(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        boolean shallow = (options & 4) == 4;
        try {
            new TCFOperationMkDir(this, shallow).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {}
        return this;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        boolean setAttribs = (options & 0x400) != 0;
        boolean setLastModified = (options & 0x800) != 0;
        try {
            if (setAttribs || setLastModified) {
                new TCFOperationPutInfo(this, info, setAttribs, setLastModified).execute(SubMonitor.convert((IProgressMonitor)monitor));
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return (InputStream)new TCFOperationOpenInputStream(this).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        boolean append = (options & 1) != 0;
        try {
            return (OutputStream)new TCFOperationOpenOutputStream(this, append).execute(SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    public void setIsArtificialRoot() {
        this.fArtificialRoot = true;
    }
}

