/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.bridge;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.internal.flash.bridge.WaXcodingConfig;
import org.eclipse.actf.model.internal.flash.proxy.HTTPLocalServerSWFFactory;
import org.eclipse.actf.model.internal.flash.proxy.ProxyTranscoderSWFFactory;
import org.eclipse.actf.model.internal.flash.proxy.SWFBootloaderFactory;
import org.eclipse.actf.model.internal.flash.proxy.SWFSecretManager;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.HTTPProxyFactory;
import org.eclipse.actf.util.httpproxy.IHTTPProxy;
import org.eclipse.actf.util.httpproxy.ProxyConfig;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServerFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoderFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverriderFactory;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.httpproxy.util.Logger;

public class WaXcodingImpl
implements IWaXcoding {
    private IHTTPProxy proxy;
    private ProxyConfig proxyConfig = new ProxyConfig();
    private ExternalProxyConfig exProxyConfig = new ExternalProxyConfig();
    public WaXcodingConfig waxConfig = WaXcodingConfig.getInstance();
    private static final String logConfig = "handlers = java.util.logging.ConsoleHandler, java.util.logging.FileHandler\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter\njava.util.logging.FileHandler.level=FINEST\njava.util.logging.FileHandler.pattern=c:/waxcoding.log\njava.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter\n";
    private static final IWaXcoding instance = new WaXcodingImpl();

    public boolean start(boolean bl) {
        if (this.proxy != null) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        if (bl) {
            byteArrayInputStream = new ByteArrayInputStream(logConfig.getBytes());
        }
        try {
            Logger.configure(byteArrayInputStream);
        }
        catch (Exception exception) {}
        this.proxy = HTTPProxyFactory.newProxy((ProxyConfig)this.proxyConfig, (ExternalProxyConfig)this.exProxyConfig);
        if (this.proxy == null) {
            return false;
        }
        this.proxy.startThread();
        return true;
    }

    public boolean stop() {
        if (this.proxy != null) {
            this.proxy.stopThread();
            this.proxy = null;
        }
        return true;
    }

    public String getSecret(String string, boolean bl) {
        return this.proxy.getSecret(string, bl);
    }

    public void setPort(int n) {
        this.proxyConfig.setPort(n);
    }

    public int getPort() {
        if (this.proxy != null) {
            return this.proxy.getListenPort();
        }
        return this.proxyConfig.getPort();
    }

    public void setExternalProxyFlag(boolean bl) {
        this.exProxyConfig.setExternalProxyFlag(bl);
    }

    public void setExternalProxy(String string, int n) {
        this.exProxyConfig.setExternalProxy(string, n);
    }

    public void setSWFTranscodingFlag(boolean bl) {
        this.waxConfig.setSWFTranscodingFlag(bl);
    }

    public void setSWFTranscodingMinimumVersion(int n) {
        this.waxConfig.setSWFTranscodingMinimumVersion(n);
    }

    public void setSWFTranscodingImposedFile(InputStream inputStream) {
        this.waxConfig.setSWFTranscodingImposedFile(inputStream);
    }

    public void setMaxConnection(int n) {
        this.proxyConfig.setMaxConnection(n);
    }

    public void setTimeout(int n) {
        this.proxyConfig.setTimeout(n);
    }

    private WaXcodingImpl() {
        this.proxyConfig.setProxyTranscoderFactory((IHTTPProxyTranscoderFactory)new ProxyTranscoderSWFFactory());
        this.proxyConfig.setSessionOverriderFactory((IHTTPSessionOverriderFactory)new SWFBootloaderFactory());
        this.proxyConfig.setLocalServerFactory((IHTTPLocalServerFactory)new HTTPLocalServerSWFFactory());
        this.proxyConfig.setSecretManager((ISecretManager)new SWFSecretManager());
    }

    public static IWaXcoding getInstance() {
        return instance;
    }

    public void setSWFBootloaderFlag(boolean bl) {
        this.waxConfig.setSWFBootloaderFlag(bl);
    }

    public void setSWFBootloader(InputStream inputStream) {
        this.waxConfig.setSWFBootLoader(inputStream);
    }

    public void setSWFBootloaderV9(InputStream inputStream) {
        this.waxConfig.setSWFBootLoaderV9(inputStream);
    }

    public void setSWFBridgeInit(InputStream inputStream) {
        this.waxConfig.setSWFBridgeInit(inputStream);
    }

    public void setSWFBridgeInitV9(InputStream inputStream) {
        this.waxConfig.setSWFBridgeInitV9(inputStream);
    }
}

