/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.Variant;

public class NativeVariantAccess {
    private int size;
    private int pVariantAddress;

    public NativeVariantAccess() {
        this(1);
    }

    public NativeVariantAccess(int n) {
        this.size = n;
        this.pVariantAddress = MemoryUtil.GlobalAlloc(Variant.sizeof * n);
        int n2 = 0;
        while (n2 < n) {
            COM.VariantInit((int)this.getAddress(n2));
            ++n2;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.size) {
            COM.VariantClear((int)this.getAddress(n));
            ++n;
        }
        MemoryUtil.GlobalFree(this.pVariantAddress);
    }

    public int getAddress() {
        return this.getAddress(0);
    }

    public int getAddress(int n) {
        return this.pVariantAddress + Variant.sizeof * n;
    }

    public short getType() {
        return this.getType(0);
    }

    public short getType(int n) {
        short[] sArray = new short[1];
        MemoryUtil.MoveMemory(sArray, this.getAddress(n), 2);
        return sArray[0];
    }

    public int getInt() {
        return this.getInt(0);
    }

    public int getInt(int n) {
        if (3 == this.getType(n)) {
            int[] nArray = new int[1];
            MemoryUtil.MoveMemory(nArray, this.getAddress(n) + 8, 4);
            return nArray[0];
        }
        return -1;
    }

    public IDispatch getDispatch() {
        return this.getDispatch(0);
    }

    public IDispatch getDispatch(int n) {
        if (9 == this.getType(n)) {
            int[] nArray = new int[1];
            MemoryUtil.MoveMemory(nArray, this.getAddress(n) + 8, 4);
            return new IDispatch(nArray[0]);
        }
        return null;
    }

    public String getString() {
        return this.getString(0);
    }

    public String getString(int n) {
        if (8 == this.getType(n)) {
            int n2;
            int[] nArray = new int[1];
            MemoryUtil.MoveMemory(nArray, this.getAddress(n) + 8, 4);
            if (nArray[0] != 0 && (n2 = COM.SysStringByteLen((int)nArray[0])) > 0) {
                char[] cArray = new char[(n2 + 1) / 2];
                MemoryUtil.MoveMemory(cArray, nArray[0], n2);
                return new String(cArray);
            }
        }
        return null;
    }

    public Variant getVariant() {
        return this.getVariant(0);
    }

    public Variant getVariant(int n) {
        switch (this.getType(n)) {
            case 3: {
                return new Variant(this.getInt(n));
            }
            case 8: {
                return new Variant(this.getString(n));
            }
            case 0: {
                return new Variant();
            }
        }
        return null;
    }
}

