/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAPropertiesView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeEntry;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class MSAAPropertiesView
extends ViewPart
implements IMSAAPropertiesView {
    private PropertyTreeViewer viewer;
    private Action refreshAction;
    private Action showNullAction;
    private Action changeColorAction;
    private Action copyAction;
    private Action invokeAction;
    private PropertiesFilter filter;
    public static final String SEPARATOR = "-";
    private static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();

    public void createPartControl(Composite composite) {
        this.viewer = new PropertyTreeViewer(composite, 98308);
        this.viewer.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.filter = new PropertiesFilter();
        this.viewer.addFilter(this.filter);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        if (MSAAViewRegistory.outlineObject != null) {
            this.setInput(MSAAViewRegistory.outlineObject);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setInput(Object object) {
        this.viewer.setInput(object);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MSAAPropertiesView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showNullAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.changeColorAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.copyAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.refreshAction);
        Object object = this.getSelectedItem();
        if (object instanceof PropertyTreeEntry && ((PropertyTreeEntry)object).canInvoke()) {
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IAction)this.invokeAction);
        }
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private Object getSelectedItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() == 1) {
            return iStructuredSelection.getFirstElement();
        }
        return null;
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.msaa_refresh){

            public void run() {
                MSAAPropertiesView.this.viewer.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.msaa_refresh);
        this.refreshAction.setImageDescriptor(GuiImages.IMAGE_REFRESH);
        this.showNullAction = new Action(Messages.msaa_showNull, 2){

            public void run() {
                ((MSAAPropertiesView)MSAAPropertiesView.this).filter.showNull = MSAAPropertiesView.this.showNullAction.isChecked();
                MSAAPropertiesView.this.viewer.refresh();
            }
        };
        this.showNullAction.setChecked(this.filter.showNull);
        this.changeColorAction = new Action(Messages.msaa_changePropertiesColor, 2){

            public void run() {
                ((MSAAPropertiesView)MSAAPropertiesView.this).filter.changeColor = MSAAPropertiesView.this.changeColorAction.isChecked();
                MSAAPropertiesView.this.viewer.refresh();
            }
        };
        this.changeColorAction.setChecked(this.filter.changeColor);
        this.copyAction = new Action(Messages.msaa_copy){

            public void run() {
                ISelection iSelection = MSAAPropertiesView.this.viewer.getSelection();
                if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
                    String string = null;
                    String string2 = null;
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (object instanceof PropertyTreeEntry) {
                        string = ((PropertyTreeEntry)object).getDisplayName();
                        string2 = ((PropertyTreeEntry)object).getValueAsString();
                    } else if (object instanceof IPropertySheetEntry) {
                        string = ((IPropertySheetEntry)object).getDisplayName();
                        string2 = ((IPropertySheetEntry)object).getValueAsString();
                    }
                    if (string != null) {
                        if (string2 != null) {
                            string = String.valueOf(string) + "\t" + string2;
                        }
                        new Clipboard(Display.getCurrent()).setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
            }
        };
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.invokeAction = new Action(Messages.msaa_invoke){

            public void run() {
                MSAAPropertiesView.this.viewer.invoke(MSAAPropertiesView.this.getSelectedItem());
            }
        };
    }

    private class PropertiesFilter
    extends ViewerFilter {
        public boolean showNull = false;
        public boolean changeColor = false;
        public String separateColor = Integer.toString(15);
        public String hilightColor = Integer.toString(9);

        private PropertiesFilter() {
        }

        public Object[] filter(Viewer viewer, Object object, Object[] objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof PropertyTreeEntry) {
                    PropertyTreeEntry propertyTreeEntry = (PropertyTreeEntry)objectArray[n];
                    String string = propertyTreeEntry.getValueAsString();
                    if (this.showNull || !"null".equals(string)) {
                        String string2;
                        Map<String, String> map;
                        if (this.changeColor && viewer instanceof PropertyTreeViewer && !(map = ((PropertyTreeViewer)viewer).getLastContents()).isEmpty() && (string2 = map.get(propertyTreeEntry.getPath())) != null) {
                            if (string == null) {
                                string = "";
                            }
                            propertyTreeEntry.setColor(string.equals(string2) ? -1 : 9);
                        }
                        arrayList.add(propertyTreeEntry);
                    }
                } else {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return false;
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof PropertyTreeEntry) {
                PropertyTreeEntry propertyTreeEntry = (PropertyTreeEntry)object;
                if (n == 0) {
                    String string = propertyTreeEntry.getDisplayName();
                    if (propertyTreeEntry.canInvoke()) {
                        string = String.valueOf(string) + "...";
                    }
                    return string;
                }
                return propertyTreeEntry.getValueAsString();
            }
            return "";
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public Color getForeground(Object object) {
            int n;
            if (object instanceof PropertyTreeEntry && -1 != (n = ((PropertyTreeEntry)object).getColor())) {
                return Display.getCurrent().getSystemColor(n);
            }
            return null;
        }

        public Color getBackground(Object object) {
            return null;
        }
    }
}

