/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.core.resources.IResource;

public class CaseBreakChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.CaseBreakProblem";
    public static final String PARAM_LAST_CASE = "last_case_param";
    public static final String PARAM_EMPTY_CASE = "empty_case_param";
    public static final String PARAM_NO_BREAK_COMMENT = "no_break_comment";
    public static final String PARAM_ENABLE_FALLTHROUGH_QUICKFIX = "enable_fallthrough_quickfix_param";
    public static final String DEFAULT_NO_BREAK_COMMENT = "no break";
    private boolean fCheckLastCase;
    private boolean fCheckEmptyCase;
    private String fNoBreakComment;
    private Pattern fNoBreakRegex;

    private void reportProblem(IASTStatement curr) {
        this.reportProblem(ER_ID, this.getProblemLocationAtEndOfNode((IASTNode)curr), new Object[0]);
    }

    private IProblemLocation getProblemLocationAtEndOfNode(IASTNode astNode) {
        IASTFileLocation astLocation = astNode.getFileLocation();
        int line = astLocation.getEndingLineNumber();
        IProblemLocationFactory locFactory = this.getRuntime().getProblemLocationFactory();
        int offset = astLocation.getNodeOffset();
        return locFactory.createProblemLocation(this.getFile(), offset, offset + astLocation.getNodeLength(), line);
    }

    private boolean isProducedByMacroExpansion(IASTStatement statement) {
        IASTNodeLocation[] locations = statement.getNodeLocations();
        return locations.length > 0 && locations[0] instanceof IASTMacroExpansionLocation && (locations.length == 1 || locations.length == 2 && locations[1].getNodeLength() == 1);
    }

    public String getTrimmedComment(IASTComment comment) {
        String str = new String(comment.getComment());
        str = comment.isBlockComment() ? str.substring(2, str.length() - 2) : str.substring(2);
        str = str.trim();
        return str;
    }

    public IASTComment getLeadingComment(IASTStatement statement) {
        return this.getCommentMap().getLastLeadingCommentForNode((IASTNode)statement);
    }

    public IASTComment getFreestandingComment(IASTStatement statement) {
        return this.getCommentMap().getLastFreestandingCommentForNode((IASTNode)statement);
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_NO_BREAK_COMMENT, CheckersMessages.CaseBreakChecker_DefaultNoBreakCommentDescription, DEFAULT_NO_BREAK_COMMENT);
        this.addPreference(problem, PARAM_LAST_CASE, CheckersMessages.CaseBreakChecker_LastCaseDescription, Boolean.FALSE);
        this.addPreference(problem, PARAM_EMPTY_CASE, CheckersMessages.CaseBreakChecker_EmptyCaseDescription, Boolean.FALSE);
        this.addPreference(problem, PARAM_ENABLE_FALLTHROUGH_QUICKFIX, CheckersMessages.CaseBreakChecker_EnableFallthroughQuickfixDescription, Boolean.FALSE);
    }

    public void processAst(IASTTranslationUnit ast) {
        this.fCheckLastCase = (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_LAST_CASE);
        this.fCheckEmptyCase = (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_EMPTY_CASE);
        this.fNoBreakComment = (String)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_NO_BREAK_COMMENT);
        try {
            if (this.fNoBreakComment != null) {
                this.fNoBreakRegex = Pattern.compile(this.fNoBreakComment, 2);
            }
        }
        catch (PatternSyntaxException e) {
            CodanCheckersActivator.log(e);
            this.fNoBreakRegex = null;
        }
        SwitchFindingVisitor visitor = new SwitchFindingVisitor();
        ast.accept((ASTVisitor)visitor);
    }

    class SwitchFindingVisitor
    extends ASTVisitor {
        SwitchFindingVisitor() {
            this.shouldVisitStatements = true;
        }

        protected boolean isBreakOrExitStatement(IASTStatement statement) {
            return statement instanceof IASTBreakStatement || statement instanceof IASTContinueStatement || this.isExitStatement(statement);
        }

        protected boolean isExitStatement(IASTStatement statement) {
            return statement instanceof IASTReturnStatement || statement instanceof IASTGotoStatement || CxxAstUtils.isThrowStatement((IASTNode)statement) || CxxAstUtils.isExitStatement((IASTNode)statement);
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTSwitchStatement && !CaseBreakChecker.this.isProducedByMacroExpansion(statement)) {
                IASTSwitchStatement switchStmt = (IASTSwitchStatement)statement;
                IASTStatement body = switchStmt.getBody();
                if (body instanceof IASTCompoundStatement) {
                    IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
                    IASTStatement prevCase = null;
                    int i = 0;
                    while (i < statements.length) {
                        IASTStatement curr = statements[i];
                        if (curr instanceof IASTSwitchStatement) {
                            this.visit(curr);
                        }
                        IASTStatement next = null;
                        if (i < statements.length - 1) {
                            next = statements[i + 1];
                        }
                        IASTStatement prev = null;
                        if (i > 0) {
                            prev = statements[i - 1];
                        }
                        if (this.isCaseStatement(curr)) {
                            prevCase = curr;
                        }
                        if (!(prevCase == null || !this.isCaseStatement(next) && next != null || !CaseBreakChecker.this.fCheckEmptyCase && this.isCaseStatement(curr) && next != null || !CaseBreakChecker.this.fCheckLastCase && next == null || next != null && this.hasValidFallthroughAttribute(curr))) {
                            if (curr instanceof IASTNullStatement && prev != prevCase) {
                                curr = prev;
                            }
                            if (!CaseBreakChecker.this.isProducedByMacroExpansion(prevCase) && this.isFallThroughStamement(curr, false)) {
                                String str;
                                IASTComment comment = null;
                                if (next != null) {
                                    comment = CaseBreakChecker.this.getLeadingComment(next);
                                } else {
                                    comment = CaseBreakChecker.this.getFreestandingComment(statement);
                                    if (comment == null) {
                                        comment = CaseBreakChecker.this.getFreestandingComment(body);
                                    }
                                }
                                if (comment == null || !(str = CaseBreakChecker.this.getTrimmedComment(comment)).toLowerCase().contains(CaseBreakChecker.this.fNoBreakComment.toLowerCase()) && (CaseBreakChecker.this.fNoBreakRegex == null || !CaseBreakChecker.this.fNoBreakRegex.matcher(str).find())) {
                                    CaseBreakChecker.this.reportProblem(curr);
                                }
                            }
                        }
                        ++i;
                    }
                }
                return 1;
            }
            return 3;
        }

        public boolean isCaseStatement(IASTStatement statement) {
            return statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement;
        }

        public boolean isFallThroughStamement(IASTStatement body, boolean checkOnlyExit) {
            if (body == null) {
                return true;
            }
            if (body instanceof IASTCompoundStatement) {
                IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
                if (statements.length > 0) {
                    return this.isFallThroughStamement(statements[statements.length - 1], checkOnlyExit);
                }
                return true;
            }
            if (body instanceof IASTDoStatement) {
                IASTDoStatement dos = (IASTDoStatement)body;
                return this.isFallThroughStamement(dos.getBody(), true);
            }
            if (body instanceof IASTSwitchStatement) {
                IASTSwitchStatement switchs = (IASTSwitchStatement)body;
                return this.isFallThroughStamement(switchs.getBody(), true);
            }
            if (body instanceof IASTForStatement) {
                IASTForStatement fors = (IASTForStatement)body;
                return this.isFallThroughStamement(fors.getBody(), true);
            }
            if (body instanceof IASTWhileStatement) {
                IASTWhileStatement whiles = (IASTWhileStatement)body;
                return this.isFallThroughStamement(whiles.getBody(), true);
            }
            if (checkOnlyExit && this.isExitStatement(body)) {
                return false;
            }
            if (!checkOnlyExit && this.isBreakOrExitStatement(body)) {
                return false;
            }
            if (body instanceof IASTExpressionStatement) {
                return true;
            }
            if (body instanceof IASTIfStatement) {
                IASTIfStatement ifs = (IASTIfStatement)body;
                return this.isFallThroughStamement(ifs.getThenClause(), checkOnlyExit) || this.isFallThroughStamement(ifs.getElseClause(), checkOnlyExit);
            }
            return true;
        }

        public boolean hasValidFallthroughAttribute(IASTStatement statement) {
            IASTStatement lastStatement = statement;
            while (lastStatement instanceof IASTCompoundStatement && lastStatement.getChildren().length > 0) {
                IASTCompoundStatement compoundStatement = (IASTCompoundStatement)lastStatement;
                IASTStatement[] nestedStatements = compoundStatement.getStatements();
                lastStatement = nestedStatements[nestedStatements.length - 1];
            }
            return lastStatement instanceof IASTNullStatement && AttributeUtil.hasAttribute((IASTAttributeOwner)lastStatement, (String[])new String[]{"fallthrough"});
        }
    }
}

