/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Stack;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.resources.IResource;

public class ShallowCopyChecker
extends AbstractIndexAstChecker {
    public static final String PROBLEM_ID = "org.eclipse.cdt.codan.internal.checkers.ShallowCopyProblem";
    public static final String PARAM_ONLY_NEW = "onlynew";
    private boolean fOnlyNew = false;

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_ONLY_NEW, CheckersMessages.ShallowCopyChecker_OnlyNew, Boolean.FALSE);
    }

    public void processAst(IASTTranslationUnit ast) {
        this.fOnlyNew = (Boolean)this.getPreference(this.getProblemById(PROBLEM_ID, (IResource)this.getFile()), PARAM_ONLY_NEW);
        if (this.fOnlyNew) {
            ast.accept((ASTVisitor)new OnlyNewVisitor());
        } else {
            ast.accept((ASTVisitor)new AllPtrsVisitor());
        }
    }

    private boolean isPointerType(IType type) {
        type = SemanticUtil.getNestedType((IType)type, (int)1);
        return type instanceof IPointerType;
    }

    private boolean isReferenceType(IType type) {
        type = SemanticUtil.getNestedType((IType)type, (int)1);
        return type instanceof ICPPReferenceType;
    }

    private static boolean hasCopyMethods(ICPPClassType classType) {
        boolean hasCopyCtor = false;
        boolean hasCopyAssignment = false;
        ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (!hasCopyCtor && method instanceof ICPPConstructor && SemanticQueries.isCopyConstructor((ICPPConstructor)((ICPPConstructor)method))) {
                hasCopyCtor = true;
            } else if (!hasCopyAssignment && SemanticQueries.isCopyAssignmentOperator((ICPPMethod)method)) {
                hasCopyAssignment = true;
            }
            if (hasCopyAssignment && hasCopyCtor) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class AllPtrsVisitor
    extends ASTVisitor {
        AllPtrsVisitor() {
            this.shouldVisitDeclSpecifiers = true;
        }

        public int visit(IASTDeclSpecifier decl) {
            if (decl instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier spec = (ICPPASTCompositeTypeSpecifier)decl;
                IASTName className = spec.getName();
                IBinding binding = className.resolveBinding();
                if (!(binding instanceof ICPPClassType)) {
                    return 3;
                }
                try {
                    CPPSemantics.pushLookupPoint((IASTNode)className);
                    ICPPClassType classType = (ICPPClassType)binding;
                    boolean hasCopyMethods = ShallowCopyChecker.hasCopyMethods(classType);
                    ICPPField[] fields = classType.getDeclaredFields();
                    boolean hasPointers = false;
                    ICPPField[] iCPPFieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPField f = iCPPFieldArray[n2];
                        if (ShallowCopyChecker.this.isPointerType(f.getType()) || ShallowCopyChecker.this.isReferenceType(f.getType())) {
                            hasPointers = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!hasCopyMethods && hasPointers) {
                        ShallowCopyChecker.this.reportProblem(ShallowCopyChecker.PROBLEM_ID, (IASTNode)decl, new Object[0]);
                    }
                    return 3;
                }
                finally {
                    CPPSemantics.popLookupPoint();
                }
            }
            return 3;
        }
    }

    private static class CtorInfo {
        ICPPConstructor ctor = null;
        boolean hasProblem = false;
        boolean hasCopyMethods = false;

        CtorInfo() {
        }
    }

    class OnlyNewVisitor
    extends ASTVisitor {
        private final Stack<CtorInfo> constructorsStack = new Stack();

        OnlyNewVisitor() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitNames = true;
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTDeclaration declaration) {
            ICPPConstructor constructor = this.getConstructor(declaration);
            if (constructor != null) {
                CtorInfo info = this.constructorsStack.push(new CtorInfo());
                info.ctor = constructor;
                info.hasProblem = false;
                try {
                    CPPSemantics.pushLookupPoint((IASTNode)declaration);
                    ICPPClassType classType = constructor.getClassOwner();
                    info.hasCopyMethods = ShallowCopyChecker.hasCopyMethods(classType);
                    return 3;
                }
                finally {
                    CPPSemantics.popLookupPoint();
                }
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            if (this.getConstructor(declaration) != null) {
                CtorInfo info = this.constructorsStack.pop();
                if (info.hasProblem) {
                    ShallowCopyChecker.this.reportProblem(ShallowCopyChecker.PROBLEM_ID, (IASTNode)declaration, new Object[0]);
                }
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (!this.constructorsStack.isEmpty() && expression instanceof IASTBinaryExpression && ((IASTBinaryExpression)expression).getOperator() == 17) {
                CtorInfo info = this.constructorsStack.peek();
                if (info.hasCopyMethods) {
                    return 3;
                }
                IASTExpression exp1 = ((IASTBinaryExpression)expression).getOperand1();
                IASTExpression exp2 = ((IASTBinaryExpression)expression).getOperand2();
                if (exp1 instanceof ICPPASTNewExpression) {
                    IBinding fBinding = null;
                    if (exp2 instanceof IASTIdExpression) {
                        fName = (IASTIdExpression)exp2;
                        fBinding = fName.getName().resolveBinding();
                    } else if (exp2 instanceof ICPPASTFieldReference) {
                        fName = (ICPPASTFieldReference)exp2;
                        fBinding = fName.getFieldName().resolveBinding();
                    }
                    if (fBinding != null && fBinding instanceof ICPPField) {
                        ICPPField field = (ICPPField)fBinding;
                        if (info.ctor.getClassOwner().equals(field.getClassOwner())) {
                            info.hasProblem = true;
                        }
                    }
                } else if (exp2 instanceof ICPPASTNewExpression) {
                    IBinding fBinding = null;
                    if (exp1 instanceof IASTIdExpression) {
                        fName = (IASTIdExpression)exp1;
                        fBinding = fName.getName().resolveBinding();
                    } else if (exp1 instanceof ICPPASTFieldReference) {
                        fName = (ICPPASTFieldReference)exp1;
                        fBinding = fName.getFieldName().resolveBinding();
                    }
                    if (fBinding != null && fBinding instanceof ICPPField) {
                        ICPPField field = (ICPPField)fBinding;
                        if (info.ctor.getClassOwner().equals(field.getClassOwner())) {
                            info.hasProblem = true;
                        }
                    }
                }
            }
            return 3;
        }

        private ICPPConstructor getConstructor(IASTDeclaration decl) {
            if (decl instanceof ICPPASTFunctionDefinition) {
                ICPPASTFunctionDefinition functionDefinition = (ICPPASTFunctionDefinition)decl;
                if (functionDefinition.isDeleted()) {
                    return null;
                }
                IBinding binding = functionDefinition.getDeclarator().getName().resolveBinding();
                if (binding instanceof ICPPConstructor) {
                    ICPPConstructor constructor = (ICPPConstructor)binding;
                    if (functionDefinition.isDefaulted() && SemanticQueries.isCopyOrMoveConstructor((ICPPConstructor)constructor)) {
                        return null;
                    }
                    if (constructor.getClassOwner().getKey() == 2) {
                        return null;
                    }
                    ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = functionDefinition.getMemberInitializers();
                    int n = iCPPASTConstructorChainInitializerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPASTConstructorChainInitializer memberInitializer = iCPPASTConstructorChainInitializerArray[n2];
                        IASTName memberName = memberInitializer.getMemberInitializerId();
                        if (memberName != null) {
                            IBinding memberBinding = memberName.resolveBinding();
                            ICPPClassType classType = null;
                            if (memberBinding instanceof ICPPClassType) {
                                classType = (ICPPClassType)memberBinding;
                            } else if (memberBinding instanceof ICPPConstructor) {
                                classType = ((ICPPConstructor)memberBinding).getClassOwner();
                            }
                            if (classType instanceof ICPPDeferredClassInstance) {
                                classType = ((ICPPDeferredClassInstance)classType).getClassTemplate();
                            }
                            if (classType != null && classType.isSameType((IType)constructor.getClassOwner())) {
                                return null;
                            }
                        }
                        ++n2;
                    }
                    return constructor;
                }
            }
            return null;
        }
    }
}

