/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.resources.IResource;

public class SwitchCaseChecker
extends AbstractIndexAstChecker {
    public static final String MISS_CASE_ID = "org.eclipse.cdt.codan.internal.checkers.MissCaseProblem";
    public static final String MISS_DEFAULT_ID = "org.eclipse.cdt.codan.internal.checkers.MissDefaultProblem";
    public static final String PARAM_DEFAULT_ALL_ENUMS = "defaultWithAllEnums";
    private boolean defaultWithAllEnums = false;

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        if (problem.getId().equals(MISS_DEFAULT_ID)) {
            this.addPreference(problem, PARAM_DEFAULT_ALL_ENUMS, CheckersMessages.SwitchCaseChecker_ParameterDefaultAllEnums, Boolean.FALSE);
        }
    }

    public void processAst(IASTTranslationUnit ast) {
        IProblem pt = this.getProblemById(MISS_DEFAULT_ID, (IResource)this.getFile());
        this.defaultWithAllEnums = (Boolean)this.getPreference(pt, PARAM_DEFAULT_ALL_ENUMS);
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitStatements = true;
            }

            public int visit(IASTStatement statement) {
                if (statement instanceof IASTSwitchStatement) {
                    IASTExpression controller = ((IASTSwitchStatement)statement).getControllerExpression();
                    IASTStatement bodyStmt = ((IASTSwitchStatement)statement).getBody();
                    IType type = SemanticUtil.getUltimateType((IType)controller.getExpressionType(), (boolean)true);
                    HashSet<Number> enumValues = new HashSet<Number>();
                    boolean defaultFound = false;
                    boolean isEnumSwitch = false;
                    if (type instanceof IEnumeration) {
                        IEnumerator[] enums;
                        IEnumerator[] iEnumeratorArray = enums = ((IEnumeration)type).getEnumerators();
                        int n = enums.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IEnumerator e = iEnumeratorArray[n2];
                            enumValues.add(e.getValue().numberValue());
                            ++n2;
                        }
                        isEnumSwitch = true;
                    }
                    List<IASTStatement> statements = bodyStmt instanceof IASTCompoundStatement ? Arrays.asList(((IASTCompoundStatement)bodyStmt).getStatements()) : Collections.singletonList(bodyStmt);
                    for (IASTStatement s : statements) {
                        Number value;
                        if (s instanceof IASTDefaultStatement) {
                            defaultFound = true;
                            continue;
                        }
                        if (s instanceof IASTCaseStatement && ((IASTCaseStatement)s).getExpression() instanceof IASTIdExpression) {
                            IASTName name = ((IASTIdExpression)((IASTCaseStatement)s).getExpression()).getName();
                            IBinding binding = name.resolveBinding();
                            if (!(binding instanceof IEnumerator)) continue;
                            enumValues.remove(((IEnumerator)binding).getValue().numberValue());
                            continue;
                        }
                        if (!(s instanceof IASTCaseStatement) || !(((IASTCaseStatement)s).getExpression() instanceof IASTLiteralExpression) || (value = ValueFactory.getConstantNumericalValue((IASTExpression)((IASTCaseStatement)s).getExpression())) == null) continue;
                        enumValues.remove(value);
                    }
                    if (!defaultFound) {
                        if (isEnumSwitch && enumValues.size() != 0) {
                            SwitchCaseChecker.this.reportProblem(SwitchCaseChecker.MISS_CASE_ID, (IASTNode)statement, new Object[0]);
                            SwitchCaseChecker.this.reportProblem(SwitchCaseChecker.MISS_DEFAULT_ID, (IASTNode)statement, new Object[0]);
                        } else if (isEnumSwitch && enumValues.size() == 0) {
                            if (SwitchCaseChecker.this.defaultWithAllEnums) {
                                SwitchCaseChecker.this.reportProblem(SwitchCaseChecker.MISS_DEFAULT_ID, (IASTNode)statement, new Object[0]);
                            }
                        } else {
                            SwitchCaseChecker.this.reportProblem(SwitchCaseChecker.MISS_DEFAULT_ID, (IASTNode)statement, new Object[0]);
                        }
                    }
                }
                return 3;
            }
        });
    }
}

