/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.MacroDefinitionParser;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpander;
import org.eclipse.cdt.internal.core.parser.scanner.PreprocessorMacro;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;

public class ObjectStyleMacro
extends PreprocessorMacro {
    private final AbstractCharArray fExpansion;
    private final int fExpansionOffset;
    private final int fEndOffset;
    private TokenList fExpansionTokens;

    public ObjectStyleMacro(char[] name, char[] expansion) {
        this(name, 0, expansion.length, null, new CharArray(expansion));
    }

    public ObjectStyleMacro(char[] name, int expansionOffset, int endOffset, TokenList expansion, AbstractCharArray source) {
        super(name);
        this.fExpansionOffset = expansionOffset;
        this.fEndOffset = endOffset;
        this.fExpansion = source;
        this.fExpansionTokens = expansion;
        if (expansion != null) {
            this.setSource(expansion.first());
        }
    }

    public int getExpansionOffset() {
        return this.fExpansionOffset;
    }

    public int getExpansionEndOffset() {
        return this.fEndOffset;
    }

    private void setSource(Token t) {
        int shift = -this.fExpansionOffset;
        while (t != null) {
            t.fSource = this;
            t.shiftOffset(shift);
            t = (Token)t.getNext();
        }
    }

    @Override
    public char[] getExpansion() {
        return MacroDefinitionParser.getExpansion(this.fExpansion, this.fExpansionOffset, this.fEndOffset);
    }

    @Override
    public char[] getExpansionImage() {
        int length = this.fEndOffset - this.fExpansionOffset;
        char[] result = new char[length];
        this.fExpansion.arraycopy(this.fExpansionOffset, result, 0, length);
        return result;
    }

    @Override
    public TokenList getTokens(MacroDefinitionParser mdp, Lexer.LexerOptions lexOptions, MacroExpander expander) {
        if (this.fExpansionTokens == null) {
            this.fExpansionTokens = new TokenList();
            Lexer lex = new Lexer(this.fExpansion, this.fExpansionOffset, this.fEndOffset, lexOptions, ILexerLog.NULL, this);
            try {
                lex.nextToken();
                mdp.parseExpansion(lex, ILexerLog.NULL, this.getNameCharArray(), this.getParameterPlaceholderList(), this.fExpansionTokens);
            }
            catch (OffsetLimitReachedException offsetLimitReachedException) {
                // empty catch block
            }
        }
        return this.fExpansionTokens;
    }

    @Override
    public final boolean isDynamic() {
        return false;
    }
}

