/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ModelEnablementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Set<ITeamContentProviderDescriptor> previosulyEnabled = new HashSet<ITeamContentProviderDescriptor>();
    private CheckboxTableViewer tableViewer;

    public ModelEnablementPreferencePage() {
        this.setTitle(TeamUIMessages.ModelEnablementPreferencePage_0);
        this.setPreferenceStore(TeamUIPlugin.getPlugin().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label l = SWTUtils.createLabel(composite, TeamUIMessages.ModelEnablementPreferencePage_1);
        l.setLayoutData((Object)new GridData(768));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof ITeamContentProviderManager) {
                    ITeamContentProviderManager manager = (ITeamContentProviderManager)element;
                    return manager.getDescriptors();
                }
                return new Object[0];
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            Map<ITeamContentProviderDescriptor, Image> images = new HashMap<ITeamContentProviderDescriptor, Image>();

            public String getText(Object element) {
                if (element instanceof ITeamContentProviderDescriptor) {
                    ITeamContentProviderDescriptor desc = (ITeamContentProviderDescriptor)element;
                    return this.getTextFor(desc);
                }
                return super.getText(element);
            }

            private String getTextFor(ITeamContentProviderDescriptor teamContentDescriptor) {
                String name = teamContentDescriptor.getName();
                if (name != null && !name.isEmpty()) {
                    return name;
                }
                String modelProviderID = teamContentDescriptor.getModelProviderId();
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)modelProviderID);
                if (desc != null) {
                    return ModelEnablementPreferencePage.this.getLabel(desc);
                }
                return modelProviderID;
            }

            public Image getImage(Object element) {
                if (element instanceof ITeamContentProviderDescriptor) {
                    ImageDescriptor idesc;
                    ITeamContentProviderDescriptor desc = (ITeamContentProviderDescriptor)element;
                    Image image = this.images.get(desc);
                    if (image == null && (idesc = desc.getImageDescriptor()) != null && (image = idesc.createImage()) != null) {
                        this.images.put(desc, image);
                    }
                    return image;
                }
                return super.getImage(element);
            }

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
                super.dispose();
            }
        });
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ITeamContentProviderDescriptor && e2 instanceof ITeamContentProviderDescriptor) {
                    ITeamContentProviderDescriptor d1 = (ITeamContentProviderDescriptor)e1;
                    ITeamContentProviderDescriptor d2 = (ITeamContentProviderDescriptor)e2;
                    IModelProviderDescriptor md1 = ModelProvider.getModelProviderDescriptor((String)d1.getModelProviderId());
                    IModelProviderDescriptor md2 = ModelProvider.getModelProviderDescriptor((String)d2.getModelProviderId());
                    if (md1 != null && md2 != null) {
                        return ModelEnablementPreferencePage.this.getLabel(md1).compareTo(ModelEnablementPreferencePage.this.getLabel(md2));
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.tableViewer.setInput((Object)TeamUI.getTeamContentProviderManager());
        this.updateChecks();
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.ui.model_preference_page_context");
        return composite;
    }

    private void updateChecks() {
        ITeamContentProviderDescriptor[] descriptors;
        ITeamContentProviderDescriptor[] iTeamContentProviderDescriptorArray = descriptors = TeamUI.getTeamContentProviderManager().getDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamContentProviderDescriptor descriptor = iTeamContentProviderDescriptorArray[n2];
            if (descriptor.isEnabled()) {
                this.previosulyEnabled.add(descriptor);
            }
            ++n2;
        }
        this.tableViewer.setCheckedElements(this.previosulyEnabled.toArray());
    }

    public boolean performOk() {
        Object[] checked = this.tableViewer.getCheckedElements();
        HashSet<ITeamContentProviderDescriptor> nowEnabled = new HashSet<ITeamContentProviderDescriptor>();
        nowEnabled.addAll(Arrays.asList(checked));
        if (this.hasDescriptorEnablementChanged(checked)) {
            TeamUI.getTeamContentProviderManager().setEnabledDescriptors(nowEnabled.toArray(new ITeamContentProviderDescriptor[nowEnabled.size()]));
            this.previosulyEnabled = nowEnabled;
        }
        return true;
    }

    private boolean hasDescriptorEnablementChanged(Object[] checked) {
        ITeamContentProviderDescriptor[] descriptors;
        ITeamContentProviderDescriptor[] iTeamContentProviderDescriptorArray = descriptors = TeamUI.getTeamContentProviderManager().getDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamContentProviderDescriptor descriptor = iTeamContentProviderDescriptorArray[n2];
            boolean enable = false;
            Object[] objectArray = checked;
            int n3 = checked.length;
            int n4 = 0;
            while (n4 < n3) {
                Object c = objectArray[n4];
                ITeamContentProviderDescriptor checkedDesc = (ITeamContentProviderDescriptor)c;
                if (checkedDesc.getModelProviderId().equals(descriptor.getModelProviderId())) {
                    enable = true;
                    break;
                }
                ++n4;
            }
            if (descriptor.isEnabled() != enable) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void performDefaults() {
        this.tableViewer.setCheckedElements((Object[])TeamUI.getTeamContentProviderManager().getDescriptors());
    }

    public void init(IWorkbench workbench) {
    }

    private String getLabel(IModelProviderDescriptor desc) {
        if (desc.getId().equals("org.eclipse.core.resources.modelProvider")) {
            try {
                return Utils.getLabel(desc.getModelProvider());
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return desc.getLabel();
    }
}

