/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SymbolsModel {
    private static final SymbolInformation ROOT_SYMBOL_INFORMATION = new SymbolInformation();
    private static final Object[] EMPTY = new Object[0];
    private volatile Map<SymbolInformation, List<SymbolInformation>> childrenMap = Collections.emptyMap();
    private volatile List<DocumentSymbol> rootSymbols = Collections.emptyList();
    private @Nullable URI uri;

    /*
     * Unable to fully structure code
     */
    public synchronized boolean update(@Nullable List<Either<SymbolInformation, DocumentSymbol>> response) {
        block3: {
            block2: {
                if (response != null && !response.isEmpty()) break block2;
                this.childrenMap = Collections.emptyMap();
                this.rootSymbols = Collections.emptyList();
                break block3;
            }
            newChildrenMap = new HashMap<SymbolInformation, List<SymbolInformation>>();
            newRootSymbols = new ArrayList<DocumentSymbol>();
            Collections.sort(response, Comparator.comparing((Function<Either, Position>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.eclipse.lsp4j.jsonrpc.messages.Either ), (Lorg/eclipse/lsp4j/jsonrpc/messages/Either;)Lorg/eclipse/lsp4j/Position;)(), Comparator.comparingInt((ToIntFunction<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$1(java.lang.Object ), (Ljava/lang/Object;)I)()).thenComparingInt((ToIntFunction<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$2(java.lang.Object ), (Ljava/lang/Object;)I)())));
            parentStack = new ArrayDeque<SymbolInformation>();
            parentStack.push(SymbolsModel.ROOT_SYMBOL_INFORMATION);
            previousSymbol = null;
            for (Either<SymbolInformation, DocumentSymbol> either : response) {
                block4: {
                    block6: {
                        block5: {
                            if (!either.isLeft()) break block4;
                            symbol = (SymbolInformation)either.getLeft();
                            if (!this.isIncluded(previousSymbol, symbol)) break block5;
                            parentStack.push(NullSafetyHelper.castNonNull(previousSymbol));
                            this.addChild(newChildrenMap, NullSafetyHelper.castNonNull((SymbolInformation)parentStack.peek()), symbol);
                            break block6;
                        }
                        if (!this.isIncluded((SymbolInformation)parentStack.peek(), symbol)) ** GOTO lbl25
                        this.addChild(newChildrenMap, NullSafetyHelper.castNonNull((SymbolInformation)parentStack.peek()), symbol);
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            parentStack.pop();
lbl25:
                            // 2 sources

                            ** while (!this.isIncluded((SymbolInformation)((SymbolInformation)parentStack.peek()), (SymbolInformation)symbol))
                        }
lbl26:
                        // 1 sources

                        this.addChild(newChildrenMap, NullSafetyHelper.castNonNull((SymbolInformation)parentStack.peek()), symbol);
                        parentStack.push(symbol);
                    }
                    previousSymbol = symbol;
                    continue;
                }
                if (!either.isRight()) continue;
                newRootSymbols.add((DocumentSymbol)either.getRight());
            }
            this.childrenMap = newChildrenMap;
            this.rootSymbols = newRootSymbols;
        }
        return true;
    }

    private boolean isIncluded(@Nullable SymbolInformation parent, @Nullable SymbolInformation symbol) {
        if (parent == null || symbol == null) {
            return false;
        }
        if (parent == ROOT_SYMBOL_INFORMATION) {
            return true;
        }
        return this.isIncluded(parent.getLocation(), symbol.getLocation());
    }

    private boolean isIncluded(Location reference, Location included) {
        return reference.getUri().equals(included.getUri()) && !reference.equals((Object)included) && this.isAfter(reference.getRange().getStart(), included.getRange().getStart()) && this.isAfter(included.getRange().getEnd(), reference.getRange().getEnd());
    }

    private boolean isAfter(Position reference, Position included) {
        return included.getLine() > reference.getLine() || included.getLine() == reference.getLine() && included.getCharacter() >= reference.getCharacter();
    }

    private void addChild(Map<SymbolInformation, List<SymbolInformation>> newChildrenMap, SymbolInformation parent, SymbolInformation child) {
        List children = newChildrenMap.computeIfAbsent(parent, key -> new ArrayList());
        children.add(child);
    }

    public Object[] getElements() {
        ArrayList<Object> res = new ArrayList<Object>(Arrays.asList(this.getChildren(ROOT_SYMBOL_INFORMATION)));
        URI current = this.uri;
        Function<DocumentSymbol, Object> mapper = current != null ? symbol -> new DocumentSymbolWithURI((DocumentSymbol)symbol, current) : symbol -> symbol;
        this.rootSymbols.stream().map(mapper).forEach(res::add);
        return res.toArray();
    }

    public Object[] getChildren(@Nullable Object parentElement) {
        if (parentElement != null) {
            if (parentElement instanceof SymbolInformation) {
                List<SymbolInformation> children = this.childrenMap.get(parentElement);
                if (children != null && !children.isEmpty()) {
                    return children.toArray();
                }
            } else if (parentElement instanceof DocumentSymbolWithURI) {
                DocumentSymbolWithURI element = (DocumentSymbolWithURI)parentElement;
                List children = element.symbol.getChildren();
                if (children != null && !children.isEmpty()) {
                    return element.symbol.getChildren().stream().map(symbol -> new DocumentSymbolWithURI((DocumentSymbol)symbol, documentSymbolWithURI.uri)).toArray();
                }
            }
        }
        return EMPTY;
    }

    public boolean hasChildren(@Nullable Object parentElement) {
        if (parentElement != null) {
            if (parentElement instanceof SymbolInformation) {
                List<SymbolInformation> children = this.childrenMap.get(parentElement);
                if (children != null) {
                    return !children.isEmpty();
                }
            } else if (parentElement instanceof DocumentSymbolWithURI) {
                DocumentSymbolWithURI element = (DocumentSymbolWithURI)parentElement;
                List children = element.symbol.getChildren();
                if (children != null) {
                    return !children.isEmpty();
                }
            }
        }
        return false;
    }

    public @Nullable Object getParent(@Nullable Object element) {
        if (element instanceof SymbolInformation) {
            for (Map.Entry<SymbolInformation, List<SymbolInformation>> entry : this.childrenMap.entrySet()) {
                if (!entry.getValue().contains(element)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void setUri(@Nullable URI uri) {
        this.uri = uri;
    }

    public @Nullable TreePath toUpdatedSymbol(TreePath initialSymbol) {
        ArrayList res = new ArrayList(initialSymbol.getSegmentCount());
        Object currentSymbol = null;
        int i = 0;
        while (i < initialSymbol.getSegmentCount()) {
            String name = this.getName(initialSymbol.getSegment(i));
            Object[] currentChildren = currentSymbol == null ? this.getElements() : this.getChildren(currentSymbol);
            if ((currentSymbol = NullSafetyHelper.castNullable(Arrays.stream(currentChildren).filter(child -> Objects.equals(this.getName(child), name)).findAny().orElse(null))) == null) {
                return null;
            }
            res.add(currentSymbol);
            ++i;
        }
        return new TreePath(res.toArray());
    }

    private @Nullable String getName(Object segment) {
        if (segment instanceof DocumentSymbolWithURI) {
            DocumentSymbolWithURI symbolWithURI = (DocumentSymbolWithURI)segment;
            segment = symbolWithURI.symbol;
        }
        if (segment instanceof DocumentSymbol) {
            DocumentSymbol documentSymbol = (DocumentSymbol)segment;
            return documentSymbol.getName();
        }
        return null;
    }

    private static /* synthetic */ Position lambda$0(Either either) {
        return either.isLeft() ? ((SymbolInformation)either.getLeft()).getLocation().getRange().getStart() : ((DocumentSymbol)either.getRight()).getRange().getStart();
    }

    private static /* synthetic */ int lambda$1(Object pos) {
        return ((Position)pos).getLine();
    }

    private static /* synthetic */ int lambda$2(Object pos) {
        return ((Position)pos).getCharacter();
    }

    @Deprecated(since="0.17.0", forRemoval=true)
    public static class DocumentSymbolWithFile {
        public final DocumentSymbol symbol;
        public final URI uri;

        public DocumentSymbolWithFile(DocumentSymbol symbol, URI uri) {
            this.symbol = symbol;
            this.uri = uri;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof DocumentSymbolWithFile) {
                DocumentSymbolWithFile other = (DocumentSymbolWithFile)obj;
                if (Objects.equals(this.symbol, other.symbol) && Objects.equals(this.uri, other.uri)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.symbol);
        }
    }

    public static class DocumentSymbolWithURI
    extends DocumentSymbolWithFile {
        public final DocumentSymbol symbol;
        public final URI uri;

        public DocumentSymbolWithURI(DocumentSymbol symbol, URI uri) {
            super(symbol, uri);
            this.symbol = symbol;
            this.uri = uri;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof DocumentSymbolWithURI) {
                DocumentSymbolWithURI other = (DocumentSymbolWithURI)obj;
                if (Objects.equals(this.symbol, other.symbol) && Objects.equals(this.uri, other.uri)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.uri, this.symbol);
        }
    }
}

