/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.modelhandler;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;

public class PluginContributedFactoryReader {
    private static PluginContributedFactoryReader reader = null;
    protected final String ATTR_CLASS = "class";
    protected final String ATTR_CONTENTTYPE = "contentTypeIdentiferId";
    protected final String EXTENSION_POINT_ID = "contentTypeFactoryContribution";
    protected final String TAG_NAME = "factory";

    public static synchronized PluginContributedFactoryReader getInstance() {
        if (reader == null) {
            reader = new PluginContributedFactoryReader();
        }
        return reader;
    }

    protected PluginContributedFactoryReader() {
    }

    public List getFactories(IDocumentTypeHandler handler) {
        return this.loadRegistry(handler.getId());
    }

    public List getFactories(String type) {
        return this.loadRegistry(type);
    }

    protected INodeAdapterFactory loadFactoryFromConfigurationElement(IConfigurationElement element, Object requesterType) {
        INodeAdapterFactory factory = null;
        if (element.getName().equals("factory")) {
            String contentType = element.getAttribute("contentTypeIdentiferId");
            if (!requesterType.equals(contentType)) {
                return null;
            }
            String className = element.getAttribute("class");
            if (className != null) {
                try {
                    factory = (INodeAdapterFactory)element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Logger.logException("Could not find class: " + className, e);
                }
                catch (Exception e) {
                    Logger.logException("Could not find class: " + className, e);
                }
            }
        }
        return factory;
    }

    protected List loadRegistry(Object contentType) {
        IConfigurationElement[] elements;
        Vector<INodeAdapterFactory> factoryList = null;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.wst.sse.core", "contentTypeFactoryContribution");
        if (point != null && (elements = point.getConfigurationElements()).length > 0) {
            factoryList = new Vector<INodeAdapterFactory>();
            int i = 0;
            while (i < elements.length) {
                INodeAdapterFactory factory = this.loadFactoryFromConfigurationElement(elements[i], contentType);
                if (factory != null) {
                    factoryList.add(factory);
                }
                ++i;
            }
        }
        return factoryList;
    }
}

