/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.context.ui.BrowseFilteredListener;
import org.eclipse.mylyn.internal.context.ui.Messages;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class FilteredChildrenDecorationDrawer
implements Listener {
    private static final int IMAGE_PADDING = 5;
    private final Image moreImage = CommonImages.getImage((ImageDescriptor)CommonImages.EXPAND);
    private final Image moreErrorImage = CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE);
    private static final String ID_HOVER = "mylyn-context-hover";
    private final TreeViewer treeViewer;
    private MoveListener listener;
    private final BrowseFilteredListener browseFilteredListener;

    public FilteredChildrenDecorationDrawer(TreeViewer treeViewer, BrowseFilteredListener browseFilteredListener) {
        this.treeViewer = treeViewer;
        this.browseFilteredListener = browseFilteredListener;
    }

    public boolean applyToTreeViewer() {
        Object data = this.treeViewer.getData(FilteredChildrenDecorationDrawer.class.getName());
        if (data == null || Boolean.FALSE.equals(data)) {
            this.treeViewer.setData(FilteredChildrenDecorationDrawer.class.getName(), (Object)Boolean.TRUE);
            if (this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
                this.treeViewer.getTree().addListener(42, (Listener)this);
                this.listener = new MoveListener(this.treeViewer, this.browseFilteredListener);
                this.treeViewer.getTree().addMouseMoveListener((MouseMoveListener)this.listener);
                this.treeViewer.getTree().addMouseListener((MouseListener)this.listener);
                this.treeViewer.getTree().addMouseTrackListener((MouseTrackListener)this.listener);
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        if (this.treeViewer.getTree() == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.treeViewer.setData(FilteredChildrenDecorationDrawer.class.getName(), (Object)Boolean.FALSE);
        this.treeViewer.getTree().removeListener(42, (Listener)this);
        if (this.listener != null) {
            this.treeViewer.getTree().removeMouseMoveListener((MouseMoveListener)this.listener);
            this.treeViewer.getTree().removeMouseListener((MouseListener)this.listener);
            this.treeViewer.getTree().removeMouseTrackListener((MouseTrackListener)this.listener);
            this.listener.dispose();
        }
    }

    public void handleEvent(Event event) {
        if (!(event.widget instanceof Tree)) {
            return;
        }
        switch (event.type) {
            case 42: {
                Tree tree = (Tree)event.widget;
                if (tree.isDisposed() || event.index != 0) {
                    return;
                }
                TreeItem item = this.findItem(tree, event.y);
                if (item == null || item.isDisposed()) {
                    return;
                }
                int imageStartX = this.getImageStartX(event.x, event.width, tree);
                NodeState value = (NodeState)((Object)item.getData(ID_HOVER));
                int imageStartY = event.y;
                int imageHeight = this.moreImage.getBounds().height;
                if (value != null && value.equals((Object)NodeState.MORE_ERROR)) {
                    imageHeight = this.moreErrorImage.getBounds().height;
                }
                int offset = Math.round((float)event.height / 2.0f - (float)imageHeight / 2.0f);
                imageStartY += offset;
                Rectangle clipping = event.gc.getClipping();
                if (clipping.width < imageStartX && clipping.width > 0) {
                    clipping.width += 5 + this.moreImage.getBounds().width;
                    event.gc.setClipping(clipping);
                }
                if (value != null && value.equals((Object)NodeState.MORE)) {
                    event.gc.drawImage(this.moreImage, imageStartX, imageStartY);
                    break;
                }
                if (value == null || !value.equals((Object)NodeState.MORE_ERROR)) break;
                event.gc.drawImage(this.moreErrorImage, imageStartX, imageStartY);
            }
        }
    }

    private int getImageStartX(int x, int width, Tree tree) {
        int imageStartX = x + width + 5;
        int imageEndX = imageStartX + this.moreImage.getBounds().width;
        Rectangle clientArea = tree.getClientArea();
        int currentTreeBounds = clientArea.x + clientArea.width;
        if (imageStartX > currentTreeBounds) {
            imageStartX = currentTreeBounds - this.moreImage.getBounds().width;
        }
        float tolerance = 0.0f;
        if (imageEndX > currentTreeBounds && (float)(imageEndX - currentTreeBounds) > tolerance) {
            imageStartX = currentTreeBounds - this.moreImage.getBounds().width;
        }
        return imageStartX;
    }

    private TreeItem findItem(Tree tree, int y) {
        TreeItem item = null;
        Point size = tree.getSize();
        int RATE = 17;
        int i = 0;
        while (i <= 17 && item == null) {
            int position = size.x / 17 + i * size.x / 17;
            item = tree.getItem(new Point(position, y));
            ++i;
        }
        return item;
    }

    private final class MoveListener
    implements MouseMoveListener,
    MouseListener,
    MouseTrackListener {
        private TreeItem lastItem;
        private TreeItem currentItem;
        private long lastMoveTime;
        private long startMoveTime;
        private final TreeViewer viewer;
        private final BrowseFilteredListener browseFilteredListener;
        private ToolTip toolTip;

        public MoveListener(TreeViewer viewer, BrowseFilteredListener browseFilteredListener) {
            this.viewer = viewer;
            this.browseFilteredListener = browseFilteredListener;
        }

        public void mouseEnter(MouseEvent e) {
            this.mouseMove(e);
        }

        public void mouseExit(MouseEvent e) {
            if (this.lastItem != null && !this.lastItem.isDisposed()) {
                this.lastItem.setData(FilteredChildrenDecorationDrawer.ID_HOVER, (Object)NodeState.LESS);
            }
            if (this.toolTip != null && !this.toolTip.isDisposed()) {
                this.toolTip.setVisible(false);
                this.toolTip.dispose();
                this.toolTip = null;
            }
            this.redrawTree(this.lastItem);
            this.lastItem = null;
            this.currentItem = null;
        }

        private void redrawTree(TreeItem item) {
            if (this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
                if (item != null && !item.isDisposed()) {
                    Rectangle bounds = item.getBounds();
                    Rectangle treeBounds = this.viewer.getTree().getBounds();
                    this.viewer.getTree().redraw(0, bounds.y, treeBounds.width, bounds.height, true);
                } else {
                    this.viewer.getTree().redraw();
                }
            }
        }

        public void mouseHover(MouseEvent e) {
            Tree tree;
            TreeItem item;
            if (this.toolTip == null || this.toolTip.isDisposed()) {
                this.toolTip = new ToolTip(WorkbenchUtil.getShell(), PlatformUiUtil.getSwtTooltipStyle());
            }
            if (this.toolTip != null && !this.toolTip.isDisposed() && (item = FilteredChildrenDecorationDrawer.this.findItem(tree = (Tree)e.widget, e.y)) != null && !item.isDisposed()) {
                Object data = item.getData(FilteredChildrenDecorationDrawer.ID_HOVER);
                if (data == NodeState.MORE) {
                    this.toolTip.setMessage(Messages.FilteredChildrenDecorationDrawer_Show_Filtered_Children);
                } else {
                    this.toolTip.setMessage(Messages.FilteredChildrenDecorationDrawer_No_Filtered_Children);
                }
                if (this.inImageBounds(tree, item, e)) {
                    this.toolTip.setVisible(true);
                }
            }
        }

        private boolean inImageBounds(Tree tree, TreeItem item, MouseEvent e) {
            int selectedX = e.x;
            int imageStartX = FilteredChildrenDecorationDrawer.this.getImageStartX(item.getBounds().x, item.getBounds().width, tree);
            int imageEndX = imageStartX + FilteredChildrenDecorationDrawer.this.moreImage.getBounds().width;
            return selectedX > imageStartX && selectedX < imageEndX;
        }

        public void mouseMove(MouseEvent e) {
            Tree tree;
            block11: {
                block10: {
                    if (this.toolTip != null && !this.toolTip.isDisposed()) {
                        this.toolTip.setVisible(false);
                        this.toolTip.dispose();
                        this.toolTip = null;
                    }
                    if (!(e.widget instanceof Tree)) break block10;
                    tree = (Tree)e.widget;
                    if (!e.widget.isDisposed()) break block11;
                }
                return;
            }
            TreeItem item = FilteredChildrenDecorationDrawer.this.findItem(tree, e.y);
            if (item != null && !item.isDisposed()) {
                if (this.lastItem != null && !this.lastItem.isDisposed() && !this.lastItem.equals(item)) {
                    boolean redraw = this.lastItem.getData(FilteredChildrenDecorationDrawer.ID_HOVER) != NodeState.LESS;
                    this.lastItem.setData(FilteredChildrenDecorationDrawer.ID_HOVER, (Object)NodeState.LESS);
                    if (redraw) {
                        this.redrawTree(this.lastItem);
                    }
                }
                this.currentItem = item;
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastMoveTime > 250L) {
                    this.startMoveTime = currentTime;
                }
                this.lastMoveTime = currentTime;
                int delay = Math.min(100, (int)((double)(currentTime - this.startMoveTime) / 4.0));
                PlatformUI.getWorkbench().getDisplay().timerExec(delay, () -> {
                    if (this.currentItem == item && !item.isDisposed()) {
                        if (item.getData(FilteredChildrenDecorationDrawer.ID_HOVER) != NodeState.MORE_ERROR) {
                            item.setData(FilteredChildrenDecorationDrawer.ID_HOVER, (Object)NodeState.MORE);
                        }
                        if (this.lastItem == null || !this.lastItem.isDisposed() && !this.lastItem.equals(item)) {
                            this.redrawTree(this.lastItem);
                            this.redrawTree(item);
                        }
                        this.lastItem = item;
                    }
                });
            } else {
                if (this.lastItem != null && !this.lastItem.isDisposed() && !this.lastItem.equals(item)) {
                    this.lastItem.setData(FilteredChildrenDecorationDrawer.ID_HOVER, (Object)NodeState.LESS);
                    this.redrawTree(this.lastItem);
                }
                this.lastItem = item;
            }
        }

        public void dispose() {
            if (this.toolTip != null && !this.toolTip.isDisposed()) {
                this.toolTip.dispose();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Tree tree;
            block9: {
                block8: {
                    if (this.toolTip != null && !this.toolTip.isDisposed()) {
                        this.toolTip.setVisible(false);
                        this.toolTip.dispose();
                        this.toolTip = null;
                    }
                    if (!(e.widget instanceof Tree)) break block8;
                    tree = (Tree)e.widget;
                    if (!e.widget.isDisposed()) break block9;
                }
                return;
            }
            TreeItem item = FilteredChildrenDecorationDrawer.this.findItem(tree, e.y);
            if (item == null || item.isDisposed() || e.button != 1) {
                return;
            }
            int prevNumberItems = item.getItemCount();
            boolean prevHasData = true;
            if (prevNumberItems > 0) {
                boolean bl = prevHasData = item.getItem(0).getData() != null;
            }
            if (this.inImageBounds(tree, item, e)) {
                this.browseFilteredListener.setWasExternalClick(true);
                this.browseFilteredListener.unfilterSelection(this.viewer, (IStructuredSelection)new StructuredSelection(item.getData()));
                int newNumItems = item.getItemCount();
                if (newNumItems == prevNumberItems && prevHasData) {
                    item.setData(FilteredChildrenDecorationDrawer.ID_HOVER, (Object)NodeState.MORE_ERROR);
                    this.redrawTree(item);
                }
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    static enum NodeState {
        MORE,
        LESS,
        MORE_ERROR;

    }
}

