/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathAlgorithmException;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.TmfEdgeState;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.AbstractCriticalPathAlgorithm;

public class CriticalPathAlgorithmBounded
extends AbstractCriticalPathAlgorithm {
    public CriticalPathAlgorithmBounded(ITmfGraph graph) {
        super(graph);
    }

    protected void appendPathComponent(ITmfGraph criticalPath, ITmfGraph graph, ITmfVertex currentVertex, List<ITmfEdge> links) {
        IGraphWorker currentActor = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(currentVertex));
        if (links.isEmpty()) {
            ITmfEdge next = graph.getEdgeFrom(currentVertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
            if (next == null) {
                return;
            }
            criticalPath.append(criticalPath.createVertex(currentActor, next.getVertexTo().getTimestamp()), next.getEdgeContextState(), next.getLinkQualifier());
            return;
        }
        ITmfVertex b1 = (ITmfVertex)NonNullUtils.checkNotNull((Object)criticalPath.getTail(currentActor));
        ITmfEdge lnk = links.get(0);
        ITmfVertex anchor = null;
        IGraphWorker objSrc = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(lnk.getVertexFrom()));
        if (objSrc.equals(currentActor)) {
            anchor = b1;
        } else {
            anchor = criticalPath.createVertex(objSrc, currentVertex.getTimestamp());
            criticalPath.add(anchor);
            criticalPath.edge(b1, anchor);
            if (lnk.getVertexFrom().compareTo(anchor) > 0) {
                anchor = criticalPath.createVertex(objSrc, lnk.getVertexFrom().getTimestamp());
                NonNullUtils.checkNotNull((Object)criticalPath.appendUnknown(anchor));
            }
        }
        ITmfEdge prev = null;
        for (ITmfEdge link : links) {
            if (prev != null && !prev.getVertexTo().equals(link.getVertexFrom())) {
                anchor = this.copyLink(criticalPath, graph, anchor, prev.getVertexTo(), link.getVertexFrom(), Math.max(prev.getVertexTo().getTimestamp(), link.getVertexFrom().getTimestamp()), null, link.getLinkQualifier());
            }
            anchor = this.copyLink(criticalPath, graph, anchor, link.getVertexFrom(), link.getVertexTo(), link.getVertexTo().getTimestamp(), link.getEdgeContextState(), link.getLinkQualifier());
            prev = link;
        }
    }

    protected List<ITmfEdge> resolveBlockingBounded(ITmfEdge blocking, ITmfVertex bound) {
        ITmfGraph graph = this.getGraph();
        LinkedList<ITmfEdge> subPath = new LinkedList<ITmfEdge>();
        ITmfVertex junction = this.findIncoming(blocking.getVertexTo(), ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        if (junction == null) {
            return subPath;
        }
        ITmfEdge down = graph.getEdgeFrom(junction, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        if (down == null) {
            return subPath;
        }
        subPath.add(down);
        ITmfVertex vertexFrom = down.getVertexFrom();
        ITmfVertex currentBound = bound.compareTo(blocking.getVertexFrom()) < 0 ? blocking.getVertexFrom() : bound;
        ArrayDeque<ITmfVertex> stack = new ArrayDeque<ITmfVertex>();
        while (vertexFrom != null && vertexFrom.compareTo(currentBound) > 0) {
            ITmfEdge inVerticalEdge = graph.getEdgeFrom(vertexFrom, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
            if (inVerticalEdge != null && inVerticalEdge.getVertexFrom().compareTo(currentBound) <= 0) {
                subPath.add(inVerticalEdge);
                break;
            }
            ITmfEdge incomingEdge = graph.getEdgeFrom(vertexFrom, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
            if (inVerticalEdge != null && (incomingEdge == null || incomingEdge.getEdgeContextState().getEdgeState() != TmfEdgeState.BLOCK)) {
                stack.addFirst(vertexFrom);
            }
            if (incomingEdge != null) {
                if (incomingEdge.getEdgeContextState().getEdgeState() == TmfEdgeState.BLOCK) {
                    List<ITmfEdge> blockings = this.resolveBlockingBounded(incomingEdge, currentBound);
                    if (blockings.isEmpty() && incomingEdge.getEdgeContextState().isMatchable()) {
                        subPath.add(incomingEdge);
                    } else {
                        subPath.addAll(blockings);
                    }
                } else {
                    subPath.add(incomingEdge);
                }
                vertexFrom = incomingEdge.getVertexFrom();
                continue;
            }
            if (!stack.isEmpty()) {
                ITmfVertex v = (ITmfVertex)stack.removeFirst();
                while (!subPath.isEmpty() && subPath.getLast().getVertexFrom() != v) {
                    subPath.removeLast();
                }
                ITmfEdge edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
                if (edge != null) {
                    subPath.add(edge);
                    vertexFrom = edge.getVertexFrom();
                    continue;
                }
            }
            vertexFrom = null;
        }
        return subPath;
    }

    @Override
    public ITmfGraph computeCriticalPath(ITmfGraph criticalPath, ITmfVertex start, @Nullable ITmfVertex end) throws CriticalPathAlgorithmException {
        ITmfGraph graph = this.getGraph();
        IGraphWorker parent = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(start));
        criticalPath.add(criticalPath.createVertex(parent, start.getTimestamp()));
        ITmfVertex currentVertex = start;
        ITmfEdge nextEdge = graph.getEdgeFrom(currentVertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        long endTime = Long.MAX_VALUE;
        if (end != null) {
            endTime = end.getTimestamp();
        }
        while (nextEdge != null) {
            ITmfVertex nextVertex = nextEdge.getVertexTo();
            if (nextVertex.getTimestamp() >= endTime) break;
            switch (nextEdge.getEdgeContextState().getEdgeState()) {
                case PASS: {
                    IGraphWorker parentTo = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(nextEdge.getVertexTo()));
                    if (parentTo != parent) {
                        throw new CriticalPathAlgorithmException("no, the parents of horizontal edges are not always identical... shouldn't they be?");
                    }
                    ITmfVertex vertex = criticalPath.createVertex(parentTo, nextEdge.getVertexTo().getTimestamp());
                    criticalPath.append(vertex, nextEdge.getEdgeContextState(), nextEdge.getLinkQualifier());
                    break;
                }
                case BLOCK: {
                    List<ITmfEdge> links = this.resolveBlockingBounded(nextEdge, nextEdge.getVertexFrom());
                    Collections.reverse(links);
                    this.appendPathComponent(criticalPath, graph, currentVertex, links);
                    break;
                }
                default: {
                    throw new CriticalPathAlgorithmException("Illegal link type " + String.valueOf(nextEdge.getEdgeContextState().getContextEnum()));
                }
            }
            currentVertex = nextVertex;
            nextEdge = graph.getEdgeFrom(currentVertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
            if (nextEdge == null) continue;
            nextEdge = null;
        }
        return criticalPath;
    }
}

