/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WizardNewProjectReferencePage
extends WizardPage {
    private CheckboxTableViewer referenceProjectsViewer;
    private static final String REFERENCED_PROJECTS_TITLE = IDEWorkbenchMessages.WizardNewProjectReferences_title;
    private static final int PROJECT_LIST_MULTIPLIER = 15;

    public WizardNewProjectReferencePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_reference_wizard_page_context");
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setText(REFERENCED_PROJECTS_TITLE);
        referenceLabel.setFont(font);
        this.referenceProjectsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.referenceProjectsViewer.getTable().setFont(composite.getFont());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = WizardNewProjectReferencePage.getDefaultFontHeight((Control)this.referenceProjectsViewer.getTable(), 15);
        this.referenceProjectsViewer.getTable().setLayoutData((Object)data);
        this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.referenceProjectsViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.referenceProjectsViewer.setComparator(new ViewerComparator());
        this.referenceProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.setControl((Control)composite);
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] projects = ((IWorkspace)element).getRoot().getProjects();
                return projects == null ? new Object[]{} : projects;
            }
        };
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    public IProject[] getReferencedProjects() {
        Object[] elements = this.referenceProjectsViewer.getCheckedElements();
        IProject[] projects = new IProject[elements.length];
        System.arraycopy(elements, 0, projects, 0, elements.length);
        return projects;
    }
}

