/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.stream.Collectors;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;

class ExternalProcessRunner {
    private ExternalProcessRunner() {
    }

    static void run(ProcessBuilder process, InputStream in, ResultHandler stdout, ResultHandler stderr) throws IOException, CanceledException {
        String command = process.command().stream().collect(Collectors.joining(" "));
        FS.ExecutionResult result = null;
        int code = 0;
        try {
            try {
                if (GitTraceLocation.GPG.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Spawning process: " + command);
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Environment: " + process.environment());
                }
                result = FS.DETECTED.execute(process, in);
                code = result.getRc();
                if (GitTraceLocation.GPG.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stderr:\n" + ExternalProcessRunner.toString(result.getStderr()));
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stdout:\n" + ExternalProcessRunner.toString(result.getStdout()));
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Spawned process exited with exit code " + code);
                }
                if (code != 0) {
                    if (stderr != null) {
                        stderr.accept(result.getStderr());
                    }
                    throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processFailed, command, String.valueOf(Integer.toString(code)) + ": " + ExternalProcessRunner.toString(result.getStderr())));
                }
                stdout.accept(result.getStdout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processInterrupted, command), e);
            }
            catch (IOException e) {
                if (GitTraceLocation.GPG.isActive()) {
                    if (result != null) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stderr:\n" + ExternalProcessRunner.toString(result.getStderr()));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "stdout:\n" + ExternalProcessRunner.toString(result.getStdout()));
                    }
                    GitTraceLocation.getTrace().trace(GitTraceLocation.GPG.getLocation(), "Spawned process failed: " + command, (Throwable)e);
                }
                if (code != 0) {
                    throw e;
                }
                if (result != null) {
                    throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processFailed, command, ExternalProcessRunner.toString(result.getStderr())), e);
                }
                throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_processFailed, command, e.getLocalizedMessage()), e);
            }
        }
        finally {
            if (result != null) {
                if (result.getStderr() != null) {
                    result.getStderr().destroy();
                }
                if (result.getStdout() != null) {
                    result.getStdout().destroy();
                }
            }
        }
    }

    static String toString(TemporaryBuffer b) {
        if (b != null) {
            try {
                return new String(b.toByteArray(4000), SystemReader.getInstance().getDefaultCharset());
            }
            catch (IOException e) {
                Activator.logWarning(CoreText.ExternalGpgSigner_bufferError, e);
            }
        }
        return "";
    }

    static interface ResultHandler {
        public void accept(TemporaryBuffer var1) throws IOException, CanceledException;
    }
}

