/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.osgi.framework.Version;

public class OutputType
extends BuildObject
implements IOutputType {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = "";
    private IOutputType superClass;
    private String superClassId;
    private ITool parent;
    private String outputContentTypeId;
    private IContentType outputContentType;
    private String outputs;
    private String optionId;
    private String buildVariable;
    private Boolean multipleOfType;
    private String primaryInputTypeId;
    private IInputType primaryInputType;
    private Boolean primaryOutput;
    private String outputPrefix;
    private String outputNames;
    private String namePattern;
    private IConfigurationElement nameProviderElement = null;
    private IManagedOutputNameProvider nameProvider = null;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private boolean isExtensionOutputType = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private boolean rebuildState;

    public OutputType(ITool parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionOutputType = true;
        this.resolved = false;
        this.loadFromManifest(element);
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        ManagedBuildManager.addExtensionOutputType(this);
    }

    public OutputType(Tool parent, IOutputType superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOutputType = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionOutputType(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public OutputType(ITool parent, ICStorageElement element) {
        this.parent = parent;
        this.isExtensionOutputType = false;
        this.loadFromProject(element);
    }

    public OutputType(ITool parent, String Id, String name, OutputType outputType) {
        this.parent = parent;
        this.superClass = outputType.superClass;
        if (this.superClass != null && outputType.superClassId != null) {
            this.superClassId = outputType.superClassId;
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOutputType = false;
        boolean copyIds = Id.equals(outputType.id);
        if (outputType.outputContentTypeId != null) {
            this.outputContentTypeId = outputType.outputContentTypeId;
        }
        this.outputContentType = outputType.outputContentType;
        if (outputType.outputs != null) {
            this.outputs = outputType.outputs;
        }
        if (outputType.optionId != null) {
            this.optionId = outputType.optionId;
        }
        if (outputType.buildVariable != null) {
            this.buildVariable = outputType.buildVariable;
        }
        if (outputType.multipleOfType != null) {
            this.multipleOfType = outputType.multipleOfType;
        }
        if (outputType.primaryInputTypeId != null) {
            this.primaryInputTypeId = outputType.primaryInputTypeId;
        }
        this.primaryInputType = outputType.primaryInputType;
        if (outputType.primaryOutput != null) {
            this.primaryOutput = outputType.primaryOutput;
        }
        if (outputType.outputPrefix != null) {
            this.outputPrefix = outputType.outputPrefix;
        }
        if (outputType.outputNames != null) {
            this.outputNames = outputType.outputNames;
        }
        if (outputType.namePattern != null) {
            this.namePattern = outputType.namePattern;
        }
        this.nameProviderElement = outputType.nameProviderElement;
        this.nameProvider = outputType.nameProvider;
        if (copyIds) {
            this.isDirty = outputType.isDirty;
            this.rebuildState = outputType.rebuildState;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        this.outputContentTypeId = SafeStringInterner.safeIntern((String)element.getAttribute("outputContentType"));
        this.outputs = SafeStringInterner.safeIntern((String)element.getAttribute("outputs"));
        this.optionId = SafeStringInterner.safeIntern((String)element.getAttribute("option"));
        String isMOT = element.getAttribute("multipleOfType");
        if (isMOT != null) {
            this.multipleOfType = Boolean.parseBoolean(isMOT);
        }
        this.primaryInputTypeId = SafeStringInterner.safeIntern((String)element.getAttribute("primaryInputType"));
        String isPO = element.getAttribute("primaryOutput");
        if (isPO != null) {
            this.primaryOutput = Boolean.parseBoolean(isPO);
        }
        this.outputPrefix = SafeStringInterner.safeIntern((String)element.getAttribute("outputPrefix"));
        this.outputNames = SafeStringInterner.safeIntern((String)element.getAttribute("outputNames"));
        this.namePattern = SafeStringInterner.safeIntern((String)element.getAttribute("namePattern"));
        this.buildVariable = SafeStringInterner.safeIntern((String)element.getAttribute("buildVariable"));
        String nameProvider = element.getAttribute("nameProvider");
        if (nameProvider != null && element instanceof DefaultManagedConfigElement) {
            this.nameProviderElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String isPO;
        String isMOT;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionOutputType(this.superClassId);
        }
        if (element.getAttribute("outputContentType") != null) {
            this.outputContentTypeId = SafeStringInterner.safeIntern((String)element.getAttribute("outputContentType"));
        }
        if (element.getAttribute("outputs") != null) {
            this.outputs = SafeStringInterner.safeIntern((String)element.getAttribute("outputs"));
        }
        if (element.getAttribute("option") != null) {
            this.optionId = SafeStringInterner.safeIntern((String)element.getAttribute("option"));
        }
        if (element.getAttribute("multipleOfType") != null && (isMOT = element.getAttribute("multipleOfType")) != null) {
            this.multipleOfType = Boolean.parseBoolean(isMOT);
        }
        if (element.getAttribute("primaryInputType") != null) {
            this.primaryInputTypeId = SafeStringInterner.safeIntern((String)element.getAttribute("primaryInputType"));
            this.primaryInputType = this.parent.getInputTypeById(this.primaryInputTypeId);
        }
        if (element.getAttribute("primaryOutput") != null && (isPO = element.getAttribute("primaryOutput")) != null) {
            this.primaryOutput = Boolean.parseBoolean(isPO);
        }
        if (element.getAttribute("outputPrefix") != null) {
            this.outputPrefix = SafeStringInterner.safeIntern((String)element.getAttribute("outputPrefix"));
        }
        if (element.getAttribute("outputNames") != null) {
            this.outputNames = SafeStringInterner.safeIntern((String)element.getAttribute("outputNames"));
        }
        if (element.getAttribute("namePattern") != null) {
            this.namePattern = SafeStringInterner.safeIntern((String)element.getAttribute("namePattern"));
        }
        if (element.getAttribute("buildVariable") != null) {
            this.buildVariable = SafeStringInterner.safeIntern((String)element.getAttribute("buildVariable"));
        }
        element.getAttribute("nameProvider");
    }

    public void serialize(ICStorageElement element) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.outputContentTypeId != null) {
            element.setAttribute("outputContentType", this.outputContentTypeId);
        }
        if (this.outputs != null) {
            element.setAttribute("outputs", this.outputs);
        }
        if (this.optionId != null) {
            element.setAttribute("option", this.optionId);
        }
        if (this.multipleOfType != null) {
            element.setAttribute("multipleOfType", this.multipleOfType.toString());
        }
        if (this.primaryInputTypeId != null) {
            element.setAttribute("primaryInputType", this.primaryInputTypeId);
        }
        if (this.primaryOutput != null) {
            element.setAttribute("primaryOutput", this.primaryOutput.toString());
        }
        if (this.outputPrefix != null) {
            element.setAttribute("outputPrefix", this.outputPrefix);
        }
        if (this.outputNames != null) {
            element.setAttribute("outputNames", this.outputNames);
        }
        if (this.namePattern != null) {
            element.setAttribute("namePattern", this.namePattern);
        }
        if (this.buildVariable != null) {
            element.setAttribute("buildVariable", this.buildVariable);
        }
        this.isDirty = false;
    }

    @Override
    public ITool getParent() {
        return this.parent;
    }

    @Override
    public IOutputType getSuperClass() {
        return this.superClass;
    }

    @Override
    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    @Override
    public String getBuildVariable() {
        if (this.buildVariable == null) {
            if (this.superClass != null) {
                return this.superClass.getBuildVariable();
            }
            String name = this.getName();
            if (name == null || name.length() == 0) {
                name = this.getId();
            }
            Object defaultName = name.toUpperCase();
            defaultName = ((String)defaultName).replaceAll("\\W", "_");
            defaultName = (String)defaultName + "_OUTPUTS";
            return defaultName;
        }
        return this.buildVariable;
    }

    @Override
    public void setBuildVariable(String variableName) {
        if (variableName == null && this.buildVariable == null) {
            return;
        }
        if (this.buildVariable == null || variableName == null || !variableName.equals(this.buildVariable)) {
            this.buildVariable = variableName;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public boolean getMultipleOfType() {
        if (this.multipleOfType == null) {
            if (this.superClass != null) {
                return this.superClass.getMultipleOfType();
            }
            return false;
        }
        return this.multipleOfType;
    }

    @Override
    public void setMultipleOfType(boolean b) {
        if (this.multipleOfType == null || b != this.multipleOfType) {
            this.multipleOfType = b;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String getNamePattern() {
        if (this.namePattern == null) {
            if (this.superClass != null) {
                return this.superClass.getNamePattern();
            }
            return EMPTY_STRING;
        }
        return this.namePattern;
    }

    @Override
    public void setNamePattern(String pattern) {
        if (pattern == null && this.namePattern == null) {
            return;
        }
        if (this.namePattern == null || pattern == null || !pattern.equals(this.namePattern)) {
            this.namePattern = pattern;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IConfigurationElement getNameProviderElement() {
        if (this.nameProviderElement == null && this.superClass != null) {
            return ((OutputType)this.superClass).getNameProviderElement();
        }
        return this.nameProviderElement;
    }

    public void setNameProviderElement(IConfigurationElement element) {
        this.nameProviderElement = element;
        this.setDirty(true);
        this.setRebuildState(true);
    }

    @Override
    public IManagedOutputNameProvider getNameProvider() {
        if (this.nameProvider != null) {
            return this.nameProvider;
        }
        IConfigurationElement element = this.getNameProviderElement();
        if (element != null) {
            try {
                if (element.getAttribute("nameProvider") != null) {
                    this.nameProvider = (IManagedOutputNameProvider)element.createExecutableExtension("nameProvider");
                    return this.nameProvider;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getOptionId() {
        if (this.optionId == null) {
            if (this.superClass != null) {
                return this.superClass.getOptionId();
            }
            return null;
        }
        return this.optionId;
    }

    @Override
    public void setOptionId(String id) {
        if (id == null && this.optionId == null) {
            return;
        }
        if (id == null || this.optionId == null || !this.optionId.equals(id)) {
            this.optionId = id;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public IContentType getOutputContentType() {
        if (this.outputContentType == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputContentType();
            }
            return null;
        }
        return this.outputContentType;
    }

    @Override
    public void setOutputContentType(IContentType type) {
        if (this.outputContentType != type) {
            this.outputContentType = type;
            this.outputContentTypeId = this.outputContentType != null ? this.outputContentType.getId() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String[] getOutputExtensionsAttribute() {
        if (this.outputs == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputExtensionsAttribute();
            }
            return null;
        }
        return this.outputs.split(DEFAULT_SEPARATOR);
    }

    @Override
    public void setOutputExtensionsAttribute(String exts) {
        if (exts == null && this.outputs == null) {
            return;
        }
        if (this.outputs == null || exts == null || !exts.equals(this.outputs)) {
            this.outputs = exts;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public String[] getOutputExtensions(ITool tool, IProject project) {
        IContentType type = this.getOutputContentType();
        if (type != null) {
            return ((Tool)tool).getContentTypeFileSpecs(type, project);
        }
        return this.getOutputExtensionsAttribute();
    }

    @Override
    public String[] getOutputExtensions(ITool tool) {
        return this.getOutputExtensions(tool, ((Tool)tool).getProject());
    }

    @Override
    public boolean isOutputExtension(ITool tool, String ext) {
        String[] exts = this.getOutputExtensions(tool);
        if (exts != null) {
            int i = 0;
            while (i < exts.length) {
                if (ext.equals(exts[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public String getOutputPrefix() {
        if (this.outputPrefix == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputPrefix();
            }
            return EMPTY_STRING;
        }
        return this.outputPrefix;
    }

    @Override
    public void setOutputPrefix(String prefix) {
        if (prefix == null && this.outputPrefix == null) {
            return;
        }
        if (this.outputPrefix == null || prefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String[] getOutputNames() {
        if (this.outputNames == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputNames();
            }
            return null;
        }
        String[] nameTokens = this.outputNames.split(";");
        return nameTokens;
    }

    @Override
    public void setOutputNames(String names) {
        if (names == null && this.outputNames == null) {
            return;
        }
        if (this.outputNames == null || names == null || !names.equals(this.outputNames)) {
            this.outputNames = names;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public IInputType getPrimaryInputType() {
        IInputType ret = this.primaryInputType;
        if (ret == null) {
            if (this.superClass != null) {
                ret = this.superClass.getPrimaryInputType();
            }
            if (ret == null) {
                ret = this.getParent().getPrimaryInputType();
            }
        }
        return ret;
    }

    @Override
    public void setPrimaryInputType(IInputType type) {
        if (this.primaryInputType != type) {
            this.primaryInputType = type;
            this.primaryInputTypeId = this.primaryInputType != null ? this.primaryInputType.getId() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public boolean getPrimaryOutput() {
        if (this.primaryOutput == null) {
            if (this.superClass != null) {
                return this.superClass.getPrimaryOutput();
            }
            return false;
        }
        return this.primaryOutput;
    }

    @Override
    public void setPrimaryOutput(boolean b) {
        if (this.primaryOutput == null || b != this.primaryOutput) {
            this.primaryOutput = b;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionOutputType;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionOutputType) {
            return false;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionOutputType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "outputType", this.getId());
                }
            }
            IContentTypeManager manager = Platform.getContentTypeManager();
            if (this.outputContentTypeId != null && this.outputContentTypeId.length() > 0) {
                this.outputContentType = manager.getContentType(this.outputContentTypeId);
            }
            if (this.primaryInputTypeId != null && this.primaryInputTypeId.length() > 0) {
                this.primaryInputType = this.parent.getInputTypeById(this.primaryInputTypeId);
            }
        }
    }

    @Override
    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    @Override
    public Version getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
    }

    public boolean needsRebuild() {
        return this.rebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.rebuildState = rebuild;
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.superClass != null) {
            return ((OutputType)this.superClass).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    public boolean isEnabled(ITool tool) {
        if (tool.isExtensionElement()) {
            return true;
        }
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
        if (calc == null) {
            return true;
        }
        return calc.isOutputTypeEnabled(tool, this);
    }

    public boolean hasCustomSettings() {
        return false;
    }
}

