/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.eclipse.lsp4j.jsonrpc.json.adapters.JsonElementTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.TypeUtils;

public class CollectionTypeAdapter<E>
extends TypeAdapter<Collection<E>> {
    private final Gson gson;
    private final Type elementType;
    private final TypeAdapter<E> elementTypeAdapter;
    private final Supplier<Collection<E>> constructor;

    public CollectionTypeAdapter(Gson gson, Type elementType, TypeAdapter<E> elementTypeAdapter, Supplier<Collection<E>> constructor) {
        this.gson = gson;
        this.elementType = elementType;
        this.elementTypeAdapter = elementTypeAdapter;
        this.constructor = constructor;
    }

    public Collection<E> read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (peek == JsonToken.BEGIN_ARRAY) {
            Collection<Object> collection = this.constructor.get();
            in.beginArray();
            while (in.hasNext()) {
                Object instance = this.elementTypeAdapter.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }
        Collection<Object> collection = this.constructor.get();
        Object instance = this.elementTypeAdapter.read(in);
        collection.add(instance);
        return collection;
    }

    public void write(JsonWriter out, Collection<E> collection) throws IOException {
        if (collection == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (E element : collection) {
            if (element != null && this.elementType != element.getClass() && (this.elementType instanceof TypeVariable || this.elementType instanceof Class)) {
                TypeAdapter runtimeTypeAdapter = this.gson.getAdapter(TypeToken.get(element.getClass()));
                runtimeTypeAdapter.write(out, element);
                continue;
            }
            this.elementTypeAdapter.write(out, element);
        }
        out.endArray();
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Collection.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            Type[] elementTypes = TypeUtils.getElementTypes(typeToken, Collection.class);
            if (elementTypes.length != 1) {
                return null;
            }
            Type elementType = elementTypes[0];
            JsonElementTypeAdapter elementTypeAdapter = elementType == Object.class ? new JsonElementTypeAdapter(gson) : gson.getAdapter(TypeToken.get((Type)elementType));
            Supplier<Collection<Object>> constructor = this.getConstructor(typeToken.getRawType());
            return this.create(gson, elementType, elementTypeAdapter, constructor);
        }

        protected TypeAdapter<?> create(Gson gson, Type elementType, TypeAdapter<?> elementTypeAdapter, Supplier<Collection<Object>> constructor) {
            return new CollectionTypeAdapter(gson, elementType, elementTypeAdapter, constructor);
        }

        protected <E> Supplier<Collection<E>> getConstructor(Class<? extends Collection<E>> rawType) {
            try {
                Constructor constructor = rawType.getDeclaredConstructor(new Class[0]);
                return () -> {
                    try {
                        return (Collection)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JsonParseException((Throwable)e);
                    }
                };
            }
            catch (Exception e) {
                if (SortedSet.class.isAssignableFrom(rawType)) {
                    return TreeSet::new;
                }
                if (Set.class.isAssignableFrom(rawType)) {
                    return LinkedHashSet::new;
                }
                if (Queue.class.isAssignableFrom(rawType)) {
                    return LinkedList::new;
                }
                return ArrayList::new;
            }
        }
    }
}

